% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differs_from_previous.R
\name{differs_from_previous}
\alias{differs_from_previous}
\alias{not_previous}
\title{Find values in a vector that differ from the previous value}
\usage{
differs_from_previous(
  data,
  col = NULL,
  threshold = NULL,
  direction = "both",
  return_index = FALSE,
  include_first = FALSE,
  handle_na = "ignore",
  factor_conversion_warning = TRUE
)
}
\arguments{
\item{data}{\code{data.frame} or \code{vector}.

\strong{N.B.} If checking a \code{factor}, it is converted to a \code{character vector}.
This means that factors can only be used when \code{`threshold`} is \code{NULL}.
Conversion will generate a warning, which can be turned off by setting \code{`factor_conversion_warning`} to \code{FALSE}.

\strong{N.B.} If \code{`data`} is a \emph{grouped} \code{data.frame},
the function is applied group-wise and the output is a \code{list} of \code{vector}s.
The names are based on the group indices
(see \code{\link[dplyr:group_data]{dplyr::group_indices()}}).}

\item{col}{Name of column to find values that differ in. Used when \code{`data`} is
\code{data.frame}. (Character)}

\item{threshold}{Threshold to check difference to previous value to.

\code{NULL}, \emph{numeric scalar} or \emph{numeric vector with length \code{2}}.

\subsection{NULL}{
Checks if the value is different from the previous value.

Ignores \code{`direction`}.

N.B. Works for both numeric and character vectors.
}
\subsection{Numeric scalar}{
Positive number.

Negative threshold is the negated number.

N.B. Only works for numeric vectors.
}
\subsection{Numeric vector with length 2}{
Given as \code{c(negative threshold, positive threshold)}.

Negative threshold must be a negative number and positive threshold must be a positive number.

N.B. Only works for numeric vectors.
}}

\item{direction}{\code{both}, \code{positive} or \code{negative}. (character)
\subsection{both}{
Checks whether the difference to the previous value is
\itemize{
\item greater than or equal to the positive threshold.
\item less than or equal to the negative threshold.
}
}
\subsection{positive}{
Checks whether the difference to the previous value is
\itemize{
\item greater than or equal to the positive threshold.
}
}
\subsection{negative}{
Checks whether the difference to the previous value is
\itemize{
\item less than or equal to the negative threshold.
}
}}

\item{return_index}{Return indices of values that differ. (Logical)}

\item{include_first}{Whether to include the first element of the vector in the output. (Logical)}

\item{handle_na}{How to handle \code{NA}s in the column.

\subsection{"ignore"}{
Removes the \code{NA}s before finding the differing values, ensuring
that the first value after an \code{NA} will be correctly identified as new,
if it differs from the value before the \code{NA}(s).
}

\subsection{"as_element"}{
Treats all \code{NA}s as the string \code{"NA"}.
This means, that \code{threshold} must be \code{NULL} when using this method.
}

\subsection{Numeric scalar}{
A numeric value to replace \code{NA}s with.
}}

\item{factor_conversion_warning}{Whether to throw a warning when converting a \code{factor} to a \code{character}. (Logical)}
}
\value{
\code{vector} with either the differing values or the indices of the differing values.

\strong{N.B.} If \code{`data`} is a \emph{grouped} \code{data.frame},
the output is a \code{list} of \code{vector}s
with the differing values. The names are based on the group indices
(see \code{\link[dplyr:group_data]{dplyr::group_indices()}}).
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("maturing")}

Finds values, or indices of values, that differ from the previous value by some threshold(s).

Operates with both a positive and a negative threshold.
Depending on \code{`direction`}, it checks if the difference to the previous value is:
\itemize{
\item greater than or equal to the positive threshold.
\item less than or equal to the negative threshold.
}
}
\examples{
# Attach packages
library(groupdata2)

# Create a data frame
df <- data.frame(
  "a" = factor(c("a", "a", "b", "b", "c", "c")),
  "n" = c(1, 3, 6, 2, 2, 4)
)

# Get differing values in column 'a' with no threshold.
# This will simply check, if it is different to the previous value or not.
differs_from_previous(df, col = "a")

# Get indices of differing values in column 'a' with no threshold.
differs_from_previous(df, col = "a", return_index = TRUE)

# Get values, that are 2 or more greater than the previous value
differs_from_previous(df, col = "n", threshold = 2, direction = "positive")

# Get values, that are 4 or more less than the previous value
differs_from_previous(df, col = "n", threshold = 4, direction = "negative")

# Get values, that are either 2 or more greater than the previous value
# or 4 or more less than the previous value
differs_from_previous(df, col = "n", threshold = c(-4, 2), direction = "both")
}
\seealso{
Other l_starts tools: 
\code{\link{find_missing_starts}()},
\code{\link{find_starts}()},
\code{\link{group}()},
\code{\link{group_factor}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{l_starts tools}
