% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Denoise.R
\name{Denoise}
\alias{Denoise}
\title{Bayesian wavelet denoising}
\usage{
Denoise(W, alpha = 0.5, nu = 5, n.samples = 500,
  transition.mode = "Markov", method = "Nelder-Mead")
}
\arguments{
\item{W}{An object of class \code{DWT}.}

\item{alpha}{Hyperparameter controlling the global smoothness.}

\item{nu}{Hyperparameter controlling variance heterogeneity. If \code{Inf},
then the variance is identical for all nodes.}

\item{n.samples}{Number of posterior draws.}

\item{transition.mode}{Type of transition.
The two options are \code{Markov} or \code{Independent}.}

\item{method}{Method used for find maxmimum of marginal likelihood.}
}
\value{
An object of class \code{grove}.
}
\description{
This function carries out Bayesian wavelet denoising using the Normal
Inverse Gamma Markov Tree method of Ma and Soriano (2016).
}
\examples{
data <- wavethresh::DJ.EX(n = 512, noisy = TRUE, rsnr = 5)$doppler
W <- DWT(data)
ans <- Denoise(W)
}
\references{
Ma L. and Soriano J. (2016) Efficient functional ANOVA
through wavelet-domain Markov groves. arXiv:1602.03990v2 [stat.ME]
(\url{https://arxiv.org/abs/1602.03990v2}).
}

