% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/janoschek.R
\name{janoschek}
\alias{janoschek}
\alias{janoschek.inverse}
\title{Janoschek growth model}
\usage{
janoschek(t, alpha, beta, b, c)

janoschek.inverse(x, alpha, beta, b, c)
}
\arguments{
\item{t}{time}

\item{alpha}{upper asymptote}

\item{beta}{lower asymptote}

\item{b}{growth parameter}

\item{c}{shape parameter}

\item{x}{size}
}
\description{
Computes the Janoschek growth model and its inverse
\deqn{ y(t) = \alpha *(\alpha - \beta) \exp(-b * t^c)) }
}
\examples{
growth <- janoschek(0:10, 10, 2, 0.5, 2)

# Calculate inverse function
time <- janoschek.inverse(growth, 12, 2, 0.5, 2) 

}
\references{
Michael J. Panik, "Growth Curve Modeling: Theory and Applications",
John Wiley & Sons, December 2013.
}
\author{
Daniel Rodriguez
}
