% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{osqp_settings_sequence}
\alias{osqp_settings_sequence}
\alias{default_osqp_sequence}
\alias{alternate_osqp_sequence}
\title{OSQP settings sequence data frame}
\format{
A data frame with at least one row and at least one column, the \emph{most common} columns being:
\describe{
\item{max_iter}{Maximum number of iterations (integer)}
\item{sigma}{Alternating direction method of multipliers (ADMM) sigma step (double)}
\item{eps_abs}{Absolute tolerance (double)}
\item{eps_rel}{Relative tolerance (double)}
\item{eps_prim_inf}{Primal infeasibility tolerance (double)}
\item{eps_dual_inf}{Dual infeasibility tolerance (double)}
\item{polish}{Perform solution polishing (logical)}
\item{scaling}{ Number of scaling iterations (integer)}
\item{prior_scaling}{Scale problem data prior to solving with OSQP (logical)}
\item{require_polished}{Require a polished solution to stop the sequence (logical)}
\item{[\emph{any-other-OSQP-setting}]}{Value of the corresponding OSQP setting}
}
}
\usage{
# Default sequence:
# tsbalancing(..., osqp_settings_df = default_osqp_sequence)

# Alternative (slower) sequence:
# tsbalancing(..., osqp_settings_df = alternate_osqp_sequence)

# Custom-made sequence (use with caution!):
# tsbalancing(..., osqp_settings_df = <my-osqp-sequence-dataframe>)

# Single solving attempt with the default OSQP settings (not recommended!):
# tsbalancing(..., osqp_settings_df = NULL)
}
\description{
\if{html,text}{(\emph{version française: 
\url{https://StatCan.github.io/gensol-gseries/fr/reference/osqp_settings_sequence.html}})}

Data frame containing a sequence of OSQP settings for \code{\link[=tsbalancing]{tsbalancing()}} specified with argument
\code{osqp_settings_df}. The package includes two predefined OSQP settings sequence data frames:
\itemize{
\item \code{\link[=osqp_settings_sequence]{default_osqp_sequence}}: fast and effective (default \code{osqp_settings_df} argument value);
\item \code{\link[=osqp_settings_sequence]{alternate_osqp_sequence}}: geared towards precision at the expense of execution time.
}

See \code{vignette("osqp-settings-sequence-dataframe")} for the actual contents of these data frames.
}
\details{
With the exception of \code{prior_scaling} and \code{require_polished}, all columns of the data frame must
correspond to a OSQP setting. Default OSQP values are used for any setting not specified in this
data frame. Visit \url{https://osqp.org/docs/interfaces/solver_settings.html} for all available OSQP
settings. Note that the OSQP \code{verbose} setting is actually controlled through \code{\link[=tsbalancing]{tsbalancing()}} arguments
\code{quiet} and \code{display_level} (i.e., column \code{verbose} in a \emph{OSQP settings sequence data frame} would be ignored).

Each row of a \emph{OSQP settings sequence data frame} represents one attempt at solving a balancing problem
with the corresponding OSQP settings. The solving sequence stops as soon as a valid solution is obtained
(a solution for which all constraint discrepancies are smaller or equal to the tolerance
specified with \code{\link[=tsbalancing]{tsbalancing()}} argument \code{validation_tol}) unless column \code{require_polished = TRUE},
in which case a polished solution from OSQP (\code{status_polish = 1}) would also be required
to stop the sequence. Constraint discrepancies correspond to \eqn{\mathrm{max}(0, l - Ax, Ax - u)}
with constraints defined as \eqn{l \le Ax \le u}{l <= Ax <= u}. In the event where a satisfactory solution
cannot be obtained after having gone through the entire sequence, \code{\link[=tsbalancing]{tsbalancing()}} returns the solution that
generated the smallest total constraint discrepancies among valid solutions, if any, or among all solutions,
otherwise. Note that running the entire solving sequence can be \emph{enforced} by specifying \code{\link[=tsbalancing]{tsbalancing()}} argument
\code{full_sequence = TRUE}. Rows with column \code{prior_scaling = TRUE} have the problem data scaled prior to
solving with OSQP, using the average of the free (nonbinding) problem values as the scaling factor.

In addition to specifying a custom-made \emph{OSQP settings sequence data frame} with argument \code{osqp_settings_df},
one can also specify \code{osqp_settings_df = NULL} which would result in a single solving attempt with default OSQP
values for all settings along with \code{prior_scaling = FALSE} and \code{require_polished = FALSE}. Note that it is
recommended, however, to first try data frames \code{default_osqp_sequence} and \code{alternate_osqp_sequence}, along with
\code{full_sequence = TRUE} if necessary, before considering other alternatives.

Vignette \emph{OSQP Settings Sequence Data Frame} (\code{vignette("osqp-settings-sequence-dataframe")}) contains additional
information.
}
\keyword{datasets}
