% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xcov.R
\name{xcov}
\alias{xcov}
\title{Cross-covariance}
\usage{
xcov(
  x,
  y = NULL,
  maxlag = if (is.matrix(x)) nrow(x) - 1 else max(length(x), length(y)) - 1,
  scale = c("none", "biased", "unbiased", "coeff")
)
}
\arguments{
\item{x}{Input, numeric or complex vector or matrix. Must not be missing.}

\item{y}{Input, numeric or complex vector data.  If \code{x} is a matrix (not
a vector), \code{y} must be omitted. \code{y} may be omitted if \code{x} is
a vector; in this case \code{xcov} estimates the autocovariance of
\code{x}.}

\item{maxlag}{Integer scalar. Maximum covariance lag. If omitted, the
default value is \code{N-1}, where \code{N} is the greater of the lengths
of \code{x} and \code{y} or, if \code{x} is a matrix, the number of rows in
\code{x}.}

\item{scale}{Character string. Specifies the type of scaling applied to the
 covariation vector (or matrix). matched to one of:
 \describe{
   \item{"none"}{return the unscaled covariance, C}
   \item{"biased"}{return the biased average, C/N}
   \item{"unbiased"}{return the unbiased average, C(k)/(N-|k|)}
   \item{"coeff"}{return C/(covariance at lag 0)},
   where \code{k} is the lag, and \code{N} is the length of \code{x}
 }
If omitted, the default value is \code{"none"}. If \code{y} is supplied but
does not have the same length as \code{x}, scale must be \code{"none"}.}
}
\value{
A list containing the following variables:
\describe{
  \item{C}{array of covariance estimates}
  \item{lags}{vector of covariance lags \code{[-maxlag:maxlag]}}
}
The array of covariance estimates has one of the following forms:
\enumerate{
  \item Cross-covariance estimate if X and Y are vectors.
  \item Autocovariance estimate if is a vector and Y is omitted.
  \item If \code{x} is a matrix, \code{C} is a matrix containing the
  cross-covariance estimates of each column with every other column. Lag
  varies with the first index so that \code{C} has \code{2 * maxlag + 1} rows
  and \eqn{P^2} columns where \code{P} is the number of columns in \code{x}.
}
}
\description{
Compute covariance at various lags (= correlation(x-mean(x), y-mean(y))).
}
\examples{
\donttest{
N <- 128
fs <- 5
t <- seq(0, 1, length.out = N)
x <- sin(2 * pi * fs * t) + runif(N)
cl <- xcov(x, maxlag = 20, scale = 'coeff')
plot (cl$lags, cl$C, type = "h", xlab = "", ylab = "")
points (cl$lags, cl$C)
abline(h = 0)
}
}
\seealso{
\code{\link{xcorr}}.
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net}.\cr
  Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
