% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_C_from_SP}
\alias{gsw_C_from_SP}
\title{Electrical Conductivity from Practical Salinity}
\usage{
gsw_C_from_SP(SP, t, p)
}
\arguments{
\item{SP}{Practical Salinity (PSS-78) [ unitless ]. The valid range for most
`gsw` functions is from 2 to 42.}

\item{t}{in-situ temperature (ITS-90) [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
electrical conductivity [ mS/cm ]
}
\description{
Electrical conductivity (in mS/cm) from Practical Salinity.
To convert the return value to conductivity ratio,
divide by 42.9140 (the value of conductivity at S=35, T68=15, and
p=0).
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2022-10-11 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `657216dd4f5ea079b5f0e021a4163e2d26893371`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SP <- c(34.5487, 34.7275, 34.8605, 34.6810, 34.5680, 34.5600)
t <- c( 28.7856, 28.4329, 22.8103, 10.2600,  6.8863,  4.4036)
p <- c(      10,      50,     125,     250,     600,    1000)
C <- gsw_C_from_SP(SP, t, p)
stopifnot(all.equal(C, c(56.412599581571186, 56.316185602699953, 50.670369333973944,
                         38.134518936104350, 35.056577637635257, 32.986550607990118)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_C_from_SP.html}
}
\seealso{
Other things related to salinity: 
\code{\link{gsw_SA_from_SP}()},
\code{\link{gsw_SA_from_SP_Baltic}()},
\code{\link{gsw_SA_from_Sstar}()},
\code{\link{gsw_SP_from_C}()},
\code{\link{gsw_SP_from_SA}()},
\code{\link{gsw_SP_from_SK}()},
\code{\link{gsw_SP_from_SR}()},
\code{\link{gsw_SP_from_Sstar}()},
\code{\link{gsw_SR_from_SP}()},
\code{\link{gsw_Sstar_from_SA}()},
\code{\link{gsw_Sstar_from_SP}()},
\code{\link{gsw_deltaSA_from_SP}()}

Other things related to conductivity: 
\code{\link{gsw_SP_from_C}()}
}
\concept{things related to conductivity}
\concept{things related to salinity}
