% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gtfs_reference}
\alias{gtfs_reference}
\title{GTFS reference}
\format{
A list with data for every GTFS file. Each named list element (also a list) has
specifications for one GTFS file in the following structure:
\itemize{
\item{\code{File_Name}: file name including file extension (txt or geojson)}
\item{\code{File_Presence}: Presence condition applied to the file}
\item{\code{file}: file name without file extension}
\item{\code{file_ext}: file extension}
\item{\code{fields}: data.frame with parsed field specification (columns:
\code{Field_Name}, \code{Type}, \code{Presence}, \code{Description}, \code{gtfsio_type})}
\item{\code{primary_key}: primary key as vector}
\item{\code{field_types}: named vector on how GTFS types (values) should be read in gtfsio
(names). Values are the same as in \code{fields}.}
}
}
\source{
\url{https://github.com/google/transit/blob/master/gtfs/spec/en/reference.md}
}
\usage{
gtfs_reference
}
\description{
The data from the official GTFS specification document parsed to a list. Revision date:
\code{2024-08-16}.
}
\details{
GTFS Types are converted to R types in gtfsio according to the following list:
\itemize{
\item{Array = \code{geojson_array}}
\item{Color = \code{character}}
\item{Currency amount = \code{numeric}}
\item{Currency code = \code{character}}
\item{Date = \code{integer}}
\item{Email = \code{character}}
\item{Enum = \verb{character, integer}}
\item{Float = \code{numeric}}
\item{ID = \code{character}}
\item{Integer = \code{integer}}
\item{Language code = \code{character}}
\item{Latitude = \code{numeric}}
\item{Longitude = \code{numeric}}
\item{Non-negative float = \code{numeric}}
\item{Non-negative integer = \code{integer}}
\item{Non-null integer = \code{integer}}
\item{Non-zero integer = \code{integer}}
\item{Object = \code{geojson_object}}
\item{Phone number = \code{character}}
\item{Positive float = \code{numeric}}
\item{Positive integer = \code{integer}}
\item{String = \code{character}}
\item{Text = \code{character}}
\item{Text or URL or Email or Phone number = \code{character}}
\item{Time = \code{character}}
\item{Timezone = \code{character}}
\item{URL = \code{character}}
\item{Unique ID = \code{character}}
}
}
\keyword{data}
