% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_trip_segment_duration.R
\name{get_trip_segment_duration}
\alias{get_trip_segment_duration}
\title{Get trip segments' duration}
\usage{
get_trip_segment_duration(
  gtfs,
  trip_id = NULL,
  unit = "min",
  sort_sequence = FALSE
)
}
\arguments{
\item{gtfs}{A GTFS object, as created by \code{\link[=read_gtfs]{read_gtfs()}}.}

\item{trip_id}{A string vector including the \code{trip_id}s to have their
segments' duration calculated. If \code{NULL} (the default) the function
calculates the segments' duration of every \code{trip_id} in the GTFS.}

\item{unit}{A string representing the time unit in which the duration is
desired. One of \code{"s"} (seconds), \code{"min"} (minutes, the default),
\code{"h"} (hours) or \code{"d"} (days).}

\item{sort_sequence}{A logical specifying whether to sort timetables by
\code{stop_sequence}. Defaults to \code{FALSE}, otherwise spec-compliant feeds, in
which timetables points are already ordered by \code{stop_sequence}, would be
penalized through longer processing times. Durations calculated from
unordered timetables do not correctly depict the real life segment
durations.}
}
\value{
A \code{data.table} containing the segments' duration of each specified
trip.
}
\description{
Returns the duration of segments between stops of each specified \code{trip_id}.
}
\section{Details}{

A trip segment is defined as the path between two subsequent stops in the
same trip. The  duration of a segment is defined as the time difference
between its arrival time and its departure time, as specified in the
\code{stop_times} file.
}

\examples{
\dontshow{
  old_dt_threads <- data.table::setDTthreads(1)
  on.exit(data.table::setDTthreads(old_dt_threads), add = TRUE)
}
data_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")

gtfs <- read_gtfs(data_path)

trip_segment_dur <- get_trip_segment_duration(gtfs)
head(trip_segment_dur)

# use the trip_id argument to control which trips are analyzed
trip_segment_dur <- get_trip_segment_duration(gtfs, trip_id = "CPTM L07-0")
trip_segment_dur

# use the unit argument to control in which unit the durations are calculated
trip_segment_dur <- get_trip_segment_duration(gtfs, "CPTM L07-0", unit = "s")
trip_segment_dur

}
