% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_confounder.R
\name{identify_confounder}
\alias{identify_confounder}
\title{Identify Confounders Using the Change-in-Estimate Method}
\usage{
identify_confounder(
  data,
  outcome,
  exposure,
  potential_confounder,
  approach = "logit",
  threshold = 10
)
}
\arguments{
\item{data}{A data frame containing the variables.}

\item{outcome}{The name of the outcome variable (character string).}

\item{exposure}{The primary exposure variable (character string).}

\item{potential_confounder}{One or more variables to test as potential confounders.}

\item{approach}{The regression modeling approach. One of:
\code{"logit"}, \code{"log-binomial"}, \code{"poisson"},
\code{"negbin"}, \code{"robpoisson"}, or \code{"linear"}.}

\item{threshold}{Numeric. Percent change threshold to define confounding
(default = 10). If the absolute percent change exceeds this, the variable
is flagged as a confounder.}
}
\value{
If one confounder is provided, prints crude and adjusted estimates
with a confounding flag. If multiple are given, returns a tibble with:
\describe{
  \item{covariate}{Name of potential confounder.}
  \item{crude_est}{Crude effect estimate.}
  \item{adjusted_est}{Adjusted estimate including the confounder.}
  \item{pct_change}{Percent change from crude to adjusted.}
  \item{is_confounder}{Logical: whether confounding threshold is exceeded.}
}
}
\description{
Identifies whether one or more variables are confounders by comparing
the crude and adjusted effect estimates of a primary exposure on an outcome.
A variable is flagged as a confounder if its inclusion changes the estimate
by more than a specified threshold (default = 10%).
}
\details{
Supports logistic, log-binomial, Poisson, robust Poisson, negative binomial,
and linear regression approaches.


This method does not evaluate effect modification. Use causal diagrams
(e.g., DAGs) and subject-matter knowledge to supplement decisions.
}
\examples{
data <- data_PimaIndiansDiabetes
identify_confounder(
  data = data,
  outcome = "glucose",
  exposure = "insulin",
  potential_confounder = "age_cat",
  approach = "linear"
)

}
\seealso{
[check_convergence()], [interaction_models()]
}
