% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_n.tbl_survfit.R
\name{add_n.tbl_survfit}
\alias{add_n.tbl_survfit}
\title{Add N}
\usage{
\method{add_n}{tbl_survfit}(x, ...)
}
\arguments{
\item{x}{object of class "\code{tbl_survfit}"}

\item{...}{Not used}
}
\description{
For each \code{survfit()} object summarized with \code{tbl_survfit()} this function
will add the total number of observations in a new column.
}
\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed("survival")) withAutoprint(\{ # examplesIf}
library(survival)
fit1 <- survfit(Surv(ttdeath, death) ~ 1, trial)
fit2 <- survfit(Surv(ttdeath, death) ~ trt, trial)

# Example 1 ----------------------------------
list(fit1, fit2) |>
  tbl_survfit(times = c(12, 24)) |>
  add_n()
\dontshow{\}) # examplesIf}
}
