% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/periods_to_long.R
\name{periods_to_long}
\alias{periods_to_long}
\title{Transform a data frame from period format to long format}
\usage{
periods_to_long(
  data,
  start,
  stop,
  time_step = 1,
  time_name = "time",
  keep = FALSE
)
}
\arguments{
\item{data}{A data frame, or a data frame extension (e.g. a tibble).}

\item{start}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}>\cr
Time variable indicating the beginning of each row}

\item{stop}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}>\cr
Optional time variable indicating the end of each row. If not provided, it
will be derived from the dataset, considering that each row ends at the
beginning of the next one.}

\item{time_step}{(numeric) Desired value for the time variable.}

\item{time_name}{(character) Name of the time variable.}

\item{keep}{(logical) Should start and stop variable be kept in the results?}
}
\value{
A tibble.
}
\description{
Transform a data frame from period format to long format
}
\examples{
d <- dplyr::tibble(
  patient = c(1, 2, 3, 3),
  begin = c(0, 2, 0, 3),
  end = c(6, 4, 2, 8),
  covar = c("no", "yes", "no", "yes")
)
d

d |> periods_to_long(start = begin, stop = end)
d |> periods_to_long(start = begin, stop = end, time_step = 5)
}
\seealso{
\code{\link[=long_to_periods]{long_to_periods()}}
}
\keyword{manip}
