% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selector_dcar.R
\name{est_dcar}
\alias{est_dcar}
\title{DCAR Projection of the Efficient Influence Function}
\usage{
est_dcar(
  psi_ipw,
  gn_pred_natural,
  gn_pred_shifted,
  Qn_pred_natural,
  Qn_pred_shifted
)
}
\arguments{
\item{psi_ipw}{A \code{numeric} vector of IPW point estimates corresponding
to the conditional density estimates of the exposure mechanism provided in
the arguments \code{gn_pred_natural} and \code{gn_pred_shifted}.}

\item{gn_pred_natural}{A \code{matrix} of conditional density estimates of
the exposure mechanism g(A|W) along a grid of the regularization parameter,
at the natural (i.e., observed) values of the exposure.}

\item{gn_pred_shifted}{A \code{matrix} of conditional density estimates of
the exposure mechanism g(A+delta|W) along a grid of the regularization
parameter, at the shifted (i.e., counterfactual) values of the exposure.}

\item{Qn_pred_natural}{A \code{numeric} of the outcome mechanism estimate at
the natural (i.e., observed) values of the exposure. HAL regression is used
for the estimate, with the regularization term chosen by cross-validation.}

\item{Qn_pred_shifted}{A \code{numeric} of the outcome mechanism estimate at
the shifted (i.e., counterfactual) values of the exposure. HAL regression
is used for the estimate, with the regularization term chosen by
cross-validation.}
}
\description{
DCAR Projection of the Efficient Influence Function
}
\keyword{internal}
