% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.interpret.R
\name{print.interpret}
\alias{print.interpret}
\title{Print interpret object}
\usage{
\method{print}{interpret}(x, ...)
}
\arguments{
\item{x}{interpret object.}

\item{...}{Additional arguments.}
}
\value{
formatted interpret object results.
}
\description{
Formats interpretations from interpret class objects. Provides simple
interpretations of regression coefficients and Cronbach's alpha. Print
specific model interpretations (or run all), returned in sentence and
paragraph formats.
}
\examples{

#Cronbach's alpha
print(interpret(alpha(items=c("i1","i2","i3","i4","i5"), data=cas)))

#' # interpret a standard linear (OLS) regression
hos1 <- assess(formula=survey ~ program + month, data=hosprog, regression= "ols")
print(interpret(hos1)$model)

# interpret a differences-in-differences model
hos2 <- assess(formula=survey ~ ., data=hosprog, intervention = "program",
int.time="month", treatment = 5, did="two", newdata=TRUE)
interpret(hos2)$did

# interpret an interrupted time series model
hos3 <- assess(formula=survey ~ ., data=hosprog, intervention = "program",
int.time="month", its="two", interrupt = 5)
interpret(hos3)$its

}
