% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_plot.R
\name{plot_cluster_fill_counts}
\alias{plot_cluster_fill_counts}
\title{Plot Cluster Fill Counts}
\usage{
plot_cluster_fill_counts(formatted_data, facet = TRUE)
}
\arguments{
\item{formatted_data}{Data created by \code{\link[=format_template_data]{format_template_data()}},
\code{\link[=fit_model]{fit_model()}}, or \code{\link[=analyze_questioned_documents]{analyze_questioned_documents()}}}

\item{facet}{\code{TRUE} uses \code{facet_wrap} to create a subplot for each writer.
\code{FALSE} plots the data on a single plot.}
}
\value{
ggplot plot of cluster fill counts
}
\description{
Plot the cluster fill counts for each document in \code{formatted_data}.
}
\examples{
# Plot cluster fill counts for template training documents
template_data <- format_template_data(example_cluster_template)
plot_cluster_fill_counts(formatted_data = template_data, facet = TRUE)

# Plot cluster fill counts for model training documents
plot_cluster_fill_counts(formatted_data = example_model, facet = TRUE)

# Plot cluster fill counts for questioned documents
plot_cluster_fill_counts(formatted_data = example_analysis, facet = FALSE)

}
