% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniq_pkg_deps.R
\name{uniq_pkg_deps}
\alias{uniq_pkg_deps}
\title{Count unique dependencies}
\usage{
uniq_pkg_deps(
  pkg,
  dep_type = c("depends", "imports", "linkingto"),
  pak_res = NULL,
  info_method = "pak",
  order = 1
)
}
\arguments{
\item{pkg}{a package to check}

\item{dep_type}{type(s) of dependencies to look up. Valid values are
\code{c("depends", "imports", "linkingto")}}

\item{pak_res}{a pre-computed result from
\code{\link[pak:pkg_deps]{pak::pkg_deps}}}

\item{info_method}{either "pak" or "tools". The latter will use
\code{\link[tools:package_dependencies]{tools::package_dependencies}} to
look up package info.}

\item{order}{Consider combinations of this many packages. Be careful going
beyond 3.}
}
\value{
A data.table listing the packages, number of unique dependencies,
  and the unique dependencies themselves.
}
\description{
A function for package developers to count which direct
  dependencies add the most unique dependencies (direct plus downstream) in
  total.
}
\details{
Use this function to tabulate which packages have the most unique
  downstream dependencies. For a package author, these are good targets to
  prioritize for removal if possible.

  Because of the graph structure of dependencies, sometimes there isn't any
  one package that adds a lot of unique dependencies, but there is a PAIR or
  TRIPLET do. Set the \code{order} argument to check which pairs, triplets,
  etc have the most unique dependencies.
}
\examples{
uniq_pkg_deps("ggplot2", pak_res = pkg_deps_ex$ggplot2)
# ^ scales adds the most unique dependencies to ggplot2 -- 6 including itself.
# The `pak_res` argument here is a pre-computed result to avoid internet
# access while running the examples on CRAN's servers. It's not required.
}
\seealso{
\code{\link{plot_deps_graph}}
}
