% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aft_logml_post.R
\name{aft.logml.post}
\alias{aft.logml.post}
\title{Log marginal likelihood of an accelerated failure time (AFT) model under a normal/half-normal prior}
\usage{
aft.logml.post(post.samples, bridge.args = NULL)
}
\arguments{
\item{post.samples}{output from \code{\link[=aft.post]{aft.post()}} giving posterior samples of an AFT model under the normal/half-normal
prior, with an attribute called 'data' which includes the list of variables specified
in the data block of the Stan program.}

\item{bridge.args}{a \code{list} giving arguments (other than \code{samples}, \code{log_posterior}, \code{data}, \code{lb}, and \code{ub}) to
pass onto \code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}}.}
}
\value{
The function returns a \code{list} with the following objects

\describe{
\item{model}{"aft_post"}

\item{logml}{the estimated logarithm of the marginal likelihood}

\item{bs}{an object of class \code{bridge} or \code{bridge_list} containing the output from using \code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}}
to compute the logarithm of the marginal likelihood of the AFT model under the normal/half-normal prior}
}
}
\description{
Uses bridge sampling to estimate the logarithm of the marginal likelihood of an AFT model under the normal/half-normal prior.
}
\examples{
if (instantiate::stan_cmdstan_exists()) {
  if(requireNamespace("survival")){
    library(survival)
    data(E1690)
    ## take subset for speed purposes
    E1690 = E1690[1:100, ]
    ## replace 0 failure times with 0.50 days
    E1690$failtime[E1690$failtime == 0] = 0.50/365.25
    E1690$cage = as.numeric(scale(E1690$age))
    data_list = list(currdata = E1690)
    d.post = aft.post(
      formula = survival::Surv(failtime, failcens) ~ treatment + sex + cage + node_bin,
      data.list = data_list,
      dist = "weibull",
      beta.sd = 10,
      chains = 1, iter_warmup = 500, iter_sampling = 1000
    )
    aft.logml.post(
      post.samples = d.post,
      bridge.args = list(silent = TRUE)
    )
  }
}
}
\references{
Gronau, Q. F., Singmann, H., and Wagenmakers, E.-J. (2020). bridgesampling: An r package for estimating normalizing constants. Journal of Statistical Software, 92(10).
}
