% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cox_lc.R
\name{finda}
\alias{finda}
\title{Estimate the time-varying coefficients from a local-in-time Cox model}
\usage{
finda(tt, times, status, covars, start = rep(0, ncol(covars)), h = 400, ...)
}
\arguments{
\item{tt}{Time to estimate beta(t) at}

\item{times}{A vector of observed follow up times.}

\item{status}{A vector of status indicators, usually 0=alive, 1=dead.}

\item{covars}{A matrix or data frame of numeric  covariate values, with a
column for each covariate and each observation is on a separate row.}

\item{start}{A vector of length p of starting values to be passed to
\code{optim} for the numerical optimization procedure. p is the number of
covariates. Defaults to all zeroes.}

\item{h}{A single value on the time scale representing the bandwidth to use.}

\item{...}{Additional parameters to pass to \code{optim}.}
}
\value{
A vector of length p, where p is the number of covariates. The vector
is the estimated beta(t) from the local-in-time Cox model at time \code{tt}.
}
\description{
\code{finda} estimates the time-varying coefficients beta(t) at a single time
from a local-in-time Cox model. Think of it as a Cox model where the
the coefficients are allowed to vary with time. Further details can be found
in Cai and Sun (2003) and Tian et al. (2005).
}
\details{
The naming of the function \code{finda} stands for "find a(t)", where "a(t)"
is the notation used in Cai and Sun (2003) to represent the time-varying
Cox model coefficients. We also refer to "a(t)" as "beta(t)" through the documentation.

The user typically will not interact with this function, as \code{finda} is
wrapped by \code{hdslc}.
}
\references{
Cai Z and Sun Y (2003). Local linear estimation for time-dependent coefficients
  in Cox's regression models. \emph{Scandinavian Journal of Statistics}, 30: 93-111.
  \href{https://doi.org/10.1111/1467-9469.00320}{doi:10.1111/1467-9469.00320}

Tian L, Zucker D, and Wei LJ (2005). On the Cox model with time-varying
  regression coefficients. \emph{Journal of the American Statistical Association},
  100(469):172-83. \href{https://doi.org/10.1198/016214504000000845}{doi:10.1198/016214504000000845}
}

