% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heuristics.R
\name{logRegModel}
\alias{logRegModel}
\title{Logistic Regression model using cue differences as predictors}
\usage{
logRegModel(
  train_data,
  criterion_col,
  cols_to_fit,
  cue_order_fn = rankByCueValidity,
  suppress_warnings = TRUE,
  fit_name = "logRegModel"
)
}
\arguments{
\item{train_data}{Training/fitting data as a matrix or data.frame.}

\item{criterion_col}{The index of the column in train_data that has the
criterion.}

\item{cols_to_fit}{A vector of column indices in train_data, used to fit
the criterion.}

\item{cue_order_fn}{Optional argument as a function that orders cues.  This
only matters for overspecified models (e.g. too many cues for the number
of rows), in which case it affects which cues are dropped. The rightmost
cues in the order are dropped first, so the function rankByCueValidity
means cues with the lowest cueValidity in the training set will be
be dropped first.  The function must have the signature
function(train_data, criterion_col, cols_to_fit).}

\item{suppress_warnings}{Optional argument specifying whether glm warnings
should be suppressed or not. Default is TRUE.}

\item{fit_name}{Optional The name other functions can use to label output.
It defaults to the class name.}
}
\value{
An object of class logRegModel.
}
\description{
Create a logistic regression model by specifying columns and a dataset.  It
fits the model with R's glm function.
}
\details{
This version assumes you do not want to include the intercept.

For a discussion of how logistic regression works, see:
https://www.r-bloggers.com/what-does-a-generalized-linear-model-do/
Note that our criterion is the probability that row 1 is greater than row 2
when a pair is encountered.
}
