% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{angle}
\alias{angle}
\title{Angle between two subspaces}
\usage{
angle(B1, B2)
}
\arguments{
\item{B1}{first matrix}

\item{B2}{second matrix}
}
\value{
scalar value of the angle between \code{B1} and \code{B2}
}
\description{
Measures angle between two subspaces. Smallest value is 0, largest is 90
 from http://www4.stat.ncsu.edu/~li/software/GroupDR.R
 http://lexinli.biostat.berkeley.edu/softwares/dr/GroupDR.R
}
\examples{

## case where any relation between b1 and b2 is random
b1 <- matrix(rnorm(10 * 2), ncol = 2)
b2 <- matrix(rnorm(10 * 2), ncol = 2)
angle(b1, b2)

## angle here should be small
b1 <- matrix(rnorm(10 * 2), ncol = 2)
b2 <- b1 + matrix(rnorm(10 * 2, sd = 0.2), ncol = 2)
angle(b1, b2)
}
