% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hsim.R
\name{plot_hsim}
\alias{plot_hsim}
\title{Plot the result of simulate_hindex}
\usage{
plot_hsim(
  simdata,
  plot_hindex = FALSE,
  plot_halpha = FALSE,
  plot_toppapers = FALSE,
  plot_mindex = FALSE,
  subgroups = FALSE,
  group_boundaries = NULL,
  exclude_group_boundaries = FALSE,
  plot_group_diffs = FALSE
)
}
\arguments{
\item{simdata}{The result of a simulation returned
by \code{\link{simulate_hindex}}.}

\item{plot_hindex}{If this parameter is set to TRUE, the h-index values are
plotted.}

\item{plot_halpha}{If this parameter is set to TRUE, the h-alpha values are
plotted.}

\item{plot_toppapers}{If this parameter is set to TRUE, the numbers of
top-10\% papers are plotted.}

\item{plot_mindex}{If this parameter is set to TRUE, the mindex values are
plotted.}

\item{subgroups}{If this parameter is set to TRUE, the subgroups in simdata
are considered for grouping plotting the index values separately for each of
these groups.}

\item{group_boundaries}{Alternative to subgroups for specifying groups of
scientists for plotting the index values separately for these groups. Here,
the groups are specified based on the initial h-index of the agents. group_boundaries
must be a list of vectors or a vector of integers specifying the groups.
If a list is specified, each element must be a vector of length 2
representing the lower and the upper bound for the initial h-index (if the
boundaries are included in the corresponding intervals is specified by the
exclude_group_boundaries parameter).
If a vector of integers is specified, each element in group_boundaries
separates two groups such that all agents with an initial h-index below
this boundary (and equal to or above any lower boundary; if
exclude_group_boundaries is set to TRUE, the initial h-index has to be
above any lower boundary) are in the first group, and all agents with
an initial h-index equal to or above this boundary (and below any higher
boundary) are in the second group.}

\item{exclude_group_boundaries}{If this parameter is set to TRUE, the
scientists are grouped such that those scientists whose initial h-index
is equal to a boundary are not included.}

\item{plot_group_diffs}{If this parameter is specified, the difference
between the groups that are specified by group_boundaries is plotted.}
}
\value{
A ggplot object (\code{\link[ggplot2]{ggplot}}).
}
\description{
Plot the result of a simulation computed by simulate_hindex.
}
\examples{
set.seed(123)
simdata <- simulate_hindex(runs = 2, n = 20, periods = 3)
plot_hsim(simdata, plot_hindex = TRUE, plot_halpha = TRUE)
}
