% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbl_sim_hierarchical.R
\name{hbl_sim_hierarchical}
\alias{hbl_sim_hierarchical}
\title{Non-longitudinal hierarchical simulations.}
\usage{
hbl_sim_hierarchical(
  n_study = 5,
  n_group = 3,
  n_patient = 100,
  n_rep = 4,
  n_continuous = 0,
  n_binary = 0,
  constraint = FALSE,
  s_delta = 1,
  s_beta = 1,
  s_sigma = 1,
  s_lambda = 1,
  s_mu = 1,
  s_tau = 1,
  d_tau = 4,
  prior_tau = "half_t",
  covariance_current = "unstructured",
  covariance_historical = "unstructured",
  alpha = NULL,
  delta = stats::rnorm(n = (n_group - 1) * (n_rep - as.integer(constraint)), mean = 0, sd
    = s_delta),
  beta = stats::rnorm(n = n_study * (n_continuous + n_binary), mean = 0, sd = s_delta),
  sigma = stats::runif(n = n_study * n_rep, min = 0, max = s_sigma),
  mu = stats::rnorm(n = n_rep, mean = 0, sd = s_mu),
  tau = NULL,
  rho_current = stats::runif(n = 1, min = -1, max = 1),
  rho_historical = stats::runif(n = n_study - 1, min = -1, max = 1)
)
}
\arguments{
\item{n_study}{Number of studies to simulate.}

\item{n_group}{Number of groups (e.g. study arms) to simulate per study.}

\item{n_patient}{Number of patients to simulate per study per group.}

\item{n_rep}{Number of repeated measures (time points) per patient.}

\item{n_continuous}{Number of continuous covariates to simulate
(all from independent standard normal distributions).}

\item{n_binary}{Number of binary covariates to simulate
(all from independent Bernoulli distributions with p = 0.5).}

\item{constraint}{Logical of length 1, whether to pool all study arms
at baseline (first rep). Appropriate when the response is the raw
response (as opposed to change from baseline) and the first rep
(i.e. time point) is prior to treatment.}

\item{s_delta}{Numeric of length 1, prior standard deviation
of the study-by-group effect parameters \code{delta}.}

\item{s_beta}{Numeric of length 1, prior standard deviation
of the fixed effects \code{beta}.}

\item{s_sigma}{Numeric of length 1, prior upper bound
of the residual standard deviations.}

\item{s_lambda}{shape parameter of the LKJ priors
on the unstructured correlation matrices.}

\item{s_mu}{Numeric of length 1,
prior standard deviation of \code{mu}.}

\item{s_tau}{Non-negative numeric of length 1.
If \code{prior_tau} is \code{"half_t"}, then \code{s_tau} is the scale parameter of
the Student t prior of \code{tau} and analogous to the \code{sigma} parameter of
the Student-t parameterization given at
\url{https://mc-stan.org/docs/functions-reference/unbounded_continuous_distributions.html}. # nolint
If \code{prior_tau} is \code{"uniform"}, then \code{s_tau} is the upper bound of \code{tau}.
Upper bound on \code{tau} if \code{prior_tau} is \code{"uniform"}.}

\item{d_tau}{Positive numeric of length 1. Degrees of freedom of the
Student t prior of \code{tau} if \code{prior_tau} is \code{"half_t"}.}

\item{prior_tau}{Character string, family of the prior of \code{tau}.
If \code{prior_tau} equals \code{"uniform"}, then the prior on \code{tau} is
a uniform prior with lower bound 0 and upper bound \code{s_tau}.
If \code{prior_tau} equals \code{"half_t"}, then the prior on \code{tau} is a
half Student-t prior with center 0, lower bound 0, scale parameter
\code{s_tau}, and degrees of freedom \code{d_tau}. The scale parameter \code{s_tau}
is analogous to the \code{sigma} parameter of
the Student-t parameterization given at
\url{https://mc-stan.org/docs/functions-reference/unbounded_continuous_distributions.html}. # nolint}

\item{covariance_current}{Character of length 1,
covariance structure of the current study.
Possible values are \code{"unstructured"} for fully parameterized
covariance matrices, \code{"ar1"} for AR(1) covariance matrices,
and \code{"diagonal"} for residuals independent across time within
each patient. In MCMC (e.g. \code{\link[=hbl_mcmc_hierarchical]{hbl_mcmc_hierarchical()}}),
the covariance structure affects computational speed.
Unstructured covariance is slower than AR(1), and AR(1) is slower
than diagonal. This is particularly true for \code{covariance_historical}
if there are many historical studies in the data.}

\item{covariance_historical}{Same as \code{covariance_current},
but for the covariance structure of each separate historical study.
Each historical study has its own separate covariance matrix.}

\item{alpha}{Numeric vector of length \code{n_rep} for the pooled
and model and length \code{n_study * n_rep} for the
independent and hierarchical models.
\code{alpha} is the vector of control group mean parameters.
\code{alpha} enters the model by multiplying with
\verb{$matrices$x_alpha} (see the return value).
The control group in the data is the one with the
\code{group} column equal to 1.}

\item{delta}{Numeric vector of length
\code{(n_group - 1) * (n_rep - as.integer(constraint))}
of treatment effect parameters.
\code{delta} enters the model by multiplying with
\verb{$matrices$x_delta} (see the return value).
The control (non-treatment) group in the data is the one with the
\code{group} column equal to 1.}

\item{beta}{Numeric vector of \code{n_study * (n_continuous + n_binary)}
fixed effect parameters. Within each study,
the first \code{n_continuous} betas
are for the continuous covariates, and the rest are for
the binary covariates. All the \code{beta}s for one study
appear before all the \code{beta}s for the next study,
and studies are arranged in increasing order of
the sorted unique values in \verb{$data$study} in the output.
\code{betas} enters the model by multiplying with
\verb{$matrices$x_alpha} (see the return value).}

\item{sigma}{Numeric vector of \code{n_study * n_rep}
residual standard deviation parameters for each study
and rep. The elements are sorted with all the standard deviations
of study 1 first (all the reps), then all the reps of study 2, etc.}

\item{mu}{Numeric of length \code{n_rep},
mean of the control group means \code{alpha} for each rep.}

\item{tau}{Numeric of length \code{n_rep},
standard deviation of the control group means \code{alpha} for each rep.}

\item{rho_current}{Numeric of length 1 between -1 and 1,
AR(1) residual correlation parameter for the current study.}

\item{rho_historical}{Numeric of length \code{n_study - 1} between -1 and 1,
AR(1) residual correlation parameters for the historical studies.}
}
\value{
A list with the following elements:
\itemize{
\item \code{data}: tidy long-form dataset with the patient-level data.
one row per patient per rep and indicator columns for the study,
group (e.g. treatment arm), patient ID, and rep. The \code{response}
columns is the patient response. The other columns are
baseline covariates. The control group is the one with
the \code{group} column equal to 1, and the current study (non-historical)
is the one with the maximum value of the \code{study} column.
Only the current study has any non-control-group patients,
the historical studies have only the control group.
\item \code{parameters}: named list of model parameter values.
See the model specification vignette for details.
\item \code{matrices}: A named list of model matrices.
See the model specification vignette for details.
}
}
\description{
Simulate from the non-longitudinal hierarchical model.
}
\examples{
hbl_sim_hierarchical(n_continuous = 1)$data
}
\seealso{
Other simulate: 
\code{\link{hbl_sim_independent}()},
\code{\link{hbl_sim_pool}()}
}
\concept{simulate}
