% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{hltsim}
\alias{hltsim}
\title{Simulate the HLT model}
\usage{
hltsim(type, n, ntheta, lambda, id, dL, nB, beta = NULL)
}
\arguments{
\item{type}{type of model to simulate. `type = "1p"` for the partial
credit model. `type = "2p"` for the generalized partial
credit model.}

\item{n}{number of observations}

\item{ntheta}{number first-level of latent dimensions}

\item{lambda}{latent factor coefficients}

\item{id}{number of questions}

\item{dL}{number of levels for each question}

\item{nB}{number of regression parameters. nB = ncol(z).}

\item{beta}{what value to set the regression parameters.}
}
\value{
a `list` containing 
\itemize{
\item{x}{ - matrix of simulated item responses}
\item{theta}{ - matrix of true latent ability}
\item{id}{ - I.Ds for item membership to each dimension}
\item{namesx}{ - vector of column names for each item}
\item{s.cor}{ - true correlations between latent ability dimensions}
\item{s.delta}{ - true difficulty parameters}
\item{s.lambda}{ - true loading parameters}
\item{s.alpha}{ - true discrimination parameters}
}
}
\description{
Simulate the HLT model
}
\examples{
xdat = hltsim(n = 250, type = "2p", ntheta = 4, 
              lambda = c(0.5, 0.8, 0.9, 0.4), id = c(rep(0, 15),         
              rep(1, 15), rep(2, 15), rep(3, 15)), dL = 2)
mod1 = hlt(x = xdat$x, id = xdat$id, iter = 12e1, 
           burn = 6e1, delta = 0.023)

xdat = hltsim(n = 250, type = "2p", ntheta = 4, 
              lambda = c(0.5, 0.8, 0.9, 0.4), id = c(rep(0, 15),         
              rep(1, 15), rep(2, 15), rep(3, 15)), dL = 2,
              beta = c(0.5, -0.7), nB = 2)
mod2 = hlt(x = xdat$x, id = xdat$id, z = xdat$z, 
           iter = 12e1, burn = 6e1, delta = 0.023, nchains = 1)


}
