\name{hommel-package}
\alias{hommel-package}
\docType{package}
\title{
  Methods for closed testing with Simes inequality, in particular Hommel's method
}
\description{
Provides methods for closed testing using Simes local tests. In particular, calculates adjusted p-values for Hommel's multiple testing method, and provides lower confidence bounds for true discovery proportions. A robust but more conservative variant of the closed testing procedure that does not require the assumption of Simes inequality is also implemented.
}

\details{
  The starting point of the package is the \link{hommel} function. See examples there.
}
\author{
Jelle Goeman, Rosa Meijer, Thijmen Krebs.

Maintainer: Jelle Goeman <j.j.goeman@lumc.nl>
}
\references{
Hommel, G. (1988). A stagewise rejective multiple test procedure based on a modified Bonferroni test. Biometrika, 75(2), 383-386.

Meijer, R. J., Krebs, T. J., & Goeman, J. J. (2019). Hommel's procedure in linear time. Biometrical Journal, 61(1), 73-82.

Goeman, J. J., Meijer, R. J., Krebs, T. J., & Solari, A. (2019). Simultaneous control of all false discovery proportions in large-scale multiple hypothesis testing. Biometrika, 106(4), 841-856.
}

\keyword{ package }




