% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kp_ratings_tables.R
\name{kp_fourfactors}
\alias{kp_fourfactors}
\title{\strong{Get Four Factors Data}}
\usage{
kp_fourfactors(min_year, max_year = most_recent_mbb_season())
}
\arguments{
\item{min_year}{First year of data to pull}

\item{max_year}{Last year of data to pull}
}
\value{
Returns a tibble of four factors ratings\tabular{ll}{
   col_name \tab types \cr
   team \tab character \cr
   conf \tab character \cr
   adj_t \tab numeric \cr
   adj_t_rk \tab numeric \cr
   adj_o \tab numeric \cr
   adj_o_rk \tab numeric \cr
   off_e_fg_pct \tab numeric \cr
   off_e_fg_pct_rk \tab numeric \cr
   off_to_pct \tab numeric \cr
   off_to_pct_rk \tab numeric \cr
   off_or_pct \tab numeric \cr
   off_or_pct_rk \tab numeric \cr
   off_ft_rate \tab numeric \cr
   off_ft_rate_rk \tab numeric \cr
   adj_d \tab numeric \cr
   adj_d_rk \tab numeric \cr
   def_e_fg_pct \tab numeric \cr
   def_e_fg_pct_rk \tab numeric \cr
   def_to_pct \tab numeric \cr
   def_to_pct_rk \tab numeric \cr
   def_or_pct \tab numeric \cr
   def_or_pct_rk \tab numeric \cr
   def_ft_rate \tab numeric \cr
   def_ft_rate_rk \tab numeric \cr
   ncaa_seed \tab numeric \cr
   year \tab numeric \cr
}
}
\description{
\strong{Get Four Factors Data}
}
\examples{
\donttest{
   try(kp_fourfactors(min_year = 2020, max_year = 2021))
}
}
\seealso{
Other KenPom Ratings Functions: 
\code{\link{kp_efficiency}()},
\code{\link{kp_foul_trouble}()},
\code{\link{kp_height}()},
\code{\link{kp_kpoy}()},
\code{\link{kp_playerstats}()},
\code{\link{kp_pointdist}()},
\code{\link{kp_pomeroy_ratings}()},
\code{\link{kp_teamstats}()}
}
\concept{KenPom Ratings Functions}
\keyword{Factors}
\keyword{Four}
