% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_boxscore_v3.R
\name{nba_boxscoredefensivev2}
\alias{nba_boxscoredefensivev2}
\title{\strong{Get NBA Stats API Boxscore Defensive V2}}
\usage{
nba_boxscoredefensivev2(
  game_id = "0022200021",
  start_period = 0,
  end_period = 14,
  start_range = 0,
  end_range = 0,
  range_type = 0,
  ...
)
}
\arguments{
\item{game_id}{Game ID}

\item{start_period}{start_period}

\item{end_period}{end_period}

\item{start_range}{start_range}

\item{end_range}{end_range}

\item{range_type}{range_type}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
A list of data frames: home_team_player_defensive, away_team_player_defensive,
home_team_totals_defensive, away_team_totals_defensive

\strong{home_team_player_defensive}\tabular{ll}{
   col_name \tab types \cr
   game_id \tab character \cr
   away_team_id \tab integer \cr
   home_team_id \tab integer \cr
   team_id \tab integer \cr
   team_name \tab character \cr
   team_city \tab character \cr
   team_tricode \tab character \cr
   team_slug \tab character \cr
   person_id \tab integer \cr
   first_name \tab character \cr
   family_name \tab character \cr
   name_i \tab character \cr
   player_slug \tab character \cr
   position \tab character \cr
   comment \tab character \cr
   jersey_num \tab character \cr
   matchup_minutes \tab character \cr
   partial_possessions \tab numeric \cr
   switches_on \tab integer \cr
   player_points \tab integer \cr
   defensive_rebounds \tab integer \cr
   matchup_assists \tab integer \cr
   matchup_turnovers \tab integer \cr
   steals \tab integer \cr
   blocks \tab integer \cr
   matchup_field_goals_made \tab integer \cr
   matchup_field_goals_attempted \tab integer \cr
   matchup_field_goal_percentage \tab numeric \cr
   matchup_three_pointers_made \tab integer \cr
   matchup_three_pointers_attempted \tab integer \cr
   matchup_three_pointer_percentage \tab numeric \cr
}


\strong{away_team_player_defensive}\tabular{ll}{
   col_name \tab types \cr
   game_id \tab character \cr
   away_team_id \tab integer \cr
   home_team_id \tab integer \cr
   team_id \tab integer \cr
   team_name \tab character \cr
   team_city \tab character \cr
   team_tricode \tab character \cr
   team_slug \tab character \cr
   person_id \tab integer \cr
   first_name \tab character \cr
   family_name \tab character \cr
   name_i \tab character \cr
   player_slug \tab character \cr
   position \tab character \cr
   comment \tab character \cr
   jersey_num \tab character \cr
   matchup_minutes \tab character \cr
   partial_possessions \tab numeric \cr
   switches_on \tab integer \cr
   player_points \tab integer \cr
   defensive_rebounds \tab integer \cr
   matchup_assists \tab integer \cr
   matchup_turnovers \tab integer \cr
   steals \tab integer \cr
   blocks \tab integer \cr
   matchup_field_goals_made \tab integer \cr
   matchup_field_goals_attempted \tab integer \cr
   matchup_field_goal_percentage \tab numeric \cr
   matchup_three_pointers_made \tab integer \cr
   matchup_three_pointers_attempted \tab integer \cr
   matchup_three_pointer_percentage \tab numeric \cr
}


\strong{home_team_totals_defensive}\tabular{ll}{
   col_name \tab types \cr
   game_id \tab character \cr
   away_team_id \tab integer \cr
   home_team_id \tab integer \cr
   team_id \tab integer \cr
   team_name \tab character \cr
   team_city \tab character \cr
   team_tricode \tab character \cr
   team_slug \tab character \cr
}


\strong{away_team_totals_defensive}\tabular{ll}{
   col_name \tab types \cr
   game_id \tab character \cr
   away_team_id \tab integer \cr
   home_team_id \tab integer \cr
   team_id \tab integer \cr
   team_name \tab character \cr
   team_city \tab character \cr
   team_tricode \tab character \cr
   team_slug \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Boxscore Defensive V2}

\strong{Get NBA Stats API Boxscore Defensive V2}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_boxscoredefensivev2(game_id = "0022200021")
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Boxscore V3 Functions: 
\code{\link{nba_boxscoreadvancedv3}()},
\code{\link{nba_boxscorefourfactorsv3}()},
\code{\link{nba_boxscorehustlev2}()},
\code{\link{nba_boxscorematchupsv3}()},
\code{\link{nba_boxscoremiscv3}()},
\code{\link{nba_boxscoreplayertrackv3}()},
\code{\link{nba_boxscorescoringv3}()},
\code{\link{nba_boxscoretraditionalv3}()},
\code{\link{nba_boxscoreusagev3}()}
}
\author{
Saiem Gilani
}
\concept{NBA Boxscore V3 Functions}
