% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_leaders.R
\name{nba_defensehub}
\alias{nba_defensehub}
\title{\strong{Get NBA Stats API Defense Hub}}
\usage{
nba_defensehub(
  league_id = "00",
  game_scope = "Season",
  player_or_team = "Team",
  player_scope = "All Players",
  season = year_to_season(most_recent_nba_season() - 1),
  season_type = "Regular Season",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{game_scope}{Game Scope - Season, Last 10, ,Yesterday, Finals}

\item{player_or_team}{Player or Team}

\item{player_scope}{Player Scope - All Players, Rookies}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: DefenseHubStat1, DefenseHubStat10, DefenseHubStat2, DefenseHubStat3, DefenseHubStat4, DefenseHubStat5, DefenseHubStat6,
DefenseHubStat7, DefenseHubStat8, DefenseHubStat9
}
\description{
\strong{Get NBA Stats API Defense Hub}

\strong{Get NBA Stats API Defense Hub}
}
\details{
(Possibly Deprecated)

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_defensehub(league_id = '00', player_or_team = "Player")
 nba_defensehub(league_id = '00', player_or_team = "Team")
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Leaders Functions: 
\code{\link{nba_alltimeleadersgrids}()},
\code{\link{nba_assistleaders}()},
\code{\link{nba_assisttracker}()},
\code{\link{nba_homepageleaders}()},
\code{\link{nba_homepagev2}()},
\code{\link{nba_leaderstiles}()},
\code{\link{nba_leagueleaders}()}
}
\author{
Saiem Gilani
}
\concept{NBA Leaders Functions}
