% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_boxscore.R
\name{nba_hustlestatsboxscore}
\alias{nba_hustlestatsboxscore}
\title{\strong{Get NBA Stats API Hustle Stats Boxscore}}
\usage{
nba_hustlestatsboxscore(game_id, ...)
}
\arguments{
\item{game_id}{Game ID}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: HustleStatsAvailable, PlayerStats, TeamStats

\strong{HustleStatsAvailable}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   HUSTLE_STATUS \tab character \cr
}


\strong{PlayerStats}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_CITY \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   START_POSITION \tab character \cr
   COMMENT \tab character \cr
   MINUTES \tab character \cr
   PTS \tab character \cr
   CONTESTED_SHOTS \tab character \cr
   CONTESTED_SHOTS_2PT \tab character \cr
   CONTESTED_SHOTS_3PT \tab character \cr
   DEFLECTIONS \tab character \cr
   CHARGES_DRAWN \tab character \cr
   SCREEN_ASSISTS \tab character \cr
   SCREEN_AST_PTS \tab character \cr
   OFF_LOOSE_BALLS_RECOVERED \tab character \cr
   DEF_LOOSE_BALLS_RECOVERED \tab character \cr
   LOOSE_BALLS_RECOVERED \tab character \cr
   OFF_BOXOUTS \tab character \cr
   DEF_BOXOUTS \tab character \cr
   BOX_OUT_PLAYER_TEAM_REBS \tab character \cr
   BOX_OUT_PLAYER_REBS \tab character \cr
   BOX_OUTS \tab character \cr
}


\strong{TeamStats}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_CITY \tab character \cr
   MINUTES \tab character \cr
   PTS \tab character \cr
   CONTESTED_SHOTS \tab character \cr
   CONTESTED_SHOTS_2PT \tab character \cr
   CONTESTED_SHOTS_3PT \tab character \cr
   DEFLECTIONS \tab character \cr
   CHARGES_DRAWN \tab character \cr
   SCREEN_ASSISTS \tab character \cr
   SCREEN_AST_PTS \tab character \cr
   OFF_LOOSE_BALLS_RECOVERED \tab character \cr
   DEF_LOOSE_BALLS_RECOVERED \tab character \cr
   LOOSE_BALLS_RECOVERED \tab character \cr
   OFF_BOXOUTS \tab character \cr
   DEF_BOXOUTS \tab character \cr
   BOX_OUT_PLAYER_TEAM_REBS \tab character \cr
   BOX_OUT_PLAYER_REBS \tab character \cr
   BOX_OUTS \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Hustle Stats Boxscore}

\strong{Get NBA Stats API Hustle Stats Boxscore}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_hustlestatsboxscore(game_id = "0022200021")
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Boxscore Functions: 
\code{\link{nba_boxscoreadvancedv2}()},
\code{\link{nba_boxscoredefensive}()},
\code{\link{nba_boxscorefourfactorsv2}()},
\code{\link{nba_boxscorematchups}()},
\code{\link{nba_boxscoremiscv2}()},
\code{\link{nba_boxscoreplayertrackv2}()},
\code{\link{nba_boxscorescoringv2}()},
\code{\link{nba_boxscoresummaryv2}()},
\code{\link{nba_boxscoretraditionalv2}()},
\code{\link{nba_boxscoreusagev2}()},
\code{\link{nba_gamerotation}()},
\code{\link{nba_live_boxscore}()}

Other NBA Hustle Functions: 
\code{\link{nba_leaguehustlestatsplayerleaders}()},
\code{\link{nba_leaguehustlestatsplayer}()},
\code{\link{nba_leaguehustlestatsteamleaders}()},
\code{\link{nba_leaguehustlestatsteam}()}
}
\author{
Saiem Gilani
}
\concept{NBA Boxscore Functions}
\concept{NBA Hustle Functions}
