% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hover_reload_button.R
\name{hover_reload_button}
\alias{hover_reload_button}
\title{Reload button with button and icon animations}
\source{
\url{https://github.com/IanLunn/Hover}
}
\usage{
hover_reload_button(
  inputId,
  label,
  icon = NULL,
  button_animation = NULL,
  icon_animation = NULL,
  width = NULL,
  ...
)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{label}{The contents of the button or link–usually a text label, but you could also use any other HTML, like an image.}

\item{icon}{An optional icon() to appear on the button.}

\item{button_animation}{The name of the button animation.}

\item{icon_animation}{The name of the icon animation.}

\item{width}{The width of the input, e.g. '400px', or '100\%'; see validateCssUnit().}

\item{...}{Named attributes to be applied to the button or link.}
}
\description{
Animate a reload button and it's icon using
\href{https://github.com/IanLunn/Hover}{Hover.css}
Note that a reload button is just a shiny::actionButton
with onClick behavior to reload or refresh a web browser.
}
\examples{
if (interactive()) {
  library(shiny)
  library(hover)

  ui <- fluidPage(
    use_hover(),
    hover_reload_button(
      inputId = "btn",
      label = "hello hover!",
      icon = icon("refresh"),
      button_animation = "rotate",
      icon_animation = "spin"
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
