# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Count genotype combinations at 2 SNPs
#'
#' @name countNumbers
#' @param X integer matrix of genotypes
#' @return \code{count} vector of counts of 9 possible genotypes at SNP pair
#'
NULL

#' Calculate log-likelihood function
#'
#' @name loglikfun
#'
#' @param counts integer vector of observed 2-locus genotype
#' @param fAA frequency of maternal haplotype 1-1
#' @param fAB frequency of maternal haplotype 1-0
#' @param fBA frequency of maternal haplotype 0-1
#' @param fBB frequency of maternal haplotype 0-0
#' @param theta paternal recombination rate
#' @return \code{lik} value of log likelihood at parameter estimates
#'
NULL

#' Expectation Maximisation (EM) algorithm
#'
#' @name LDHScpp
#'
#' @param XGF1 integer matrix of progeny genotypes in genomic family 1
#' @param XGF2 integer matrix of progeny genotypes in genomic family 2
#' @param fAA frequency of maternal haplotype 1-1
#' @param fAB frequency of maternal haplotype 1-0
#' @param fBA frequency of maternal haplotype 0-1
#' @param theta paternal recombination rate
#' @param display logical for displaying additional information
#' @param threshold convergence criterion
#' @return list of parameter estimates
#' \describe{
#'  \item{\code{D}}{maternal LD}
#'  \item{\code{fAA}}{frequency of maternal haplotype 1-1}
#'  \item{\code{fAB}}{frequency of maternal haplotype 1-0}
#'  \item{\code{fBA}}{frequency of maternal haplotype 0-1}
#'  \item{\code{fBB}}{frequency of maternal haplotype 0-0}
#'  \item{\code{p1}}{Maternal allele frequency (allele 1) at 1. SNP}
#'  \item{\code{p2}}{Maternal allele frequency (allele 1) at 2. SNP}
#'  \item{\code{nfam1}}{size of genomic family 1}
#'  \item{\code{nfam2}}{size of genomic family 2}
#'  \item{\code{error}}{0 if computations were without error; 1 if EM algorithm
#'   did not converge}
#'  \item{\code{iteration}}{number of EM iterations}
#'  \item{\code{theta}}{paternal recombination rate}
#'  \item{\code{r2}}{\eqn{r^2} of maternal LD}
#'  \item{\code{logL}}{value of log likelihood function}
#' }
#' @export
LDHScpp <- function(XGF1, XGF2, fAA, fAB, fBA, theta, display, threshold) {
    .Call('_hsrecombi_LDHScpp', PACKAGE = 'hsrecombi', XGF1, XGF2, fAA, fAB, fBA, theta, display, threshold)
}

