% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/River_Engineering.R
\name{wt_sup}
\alias{wt_sup}
\title{Superelevation of water table in curve}
\usage{
wt_sup(w, rm, v, S = 1.5)
}
\arguments{
\item{w}{Numeric. Horizontal sole width [m].}

\item{rm}{Numeric. Curve radius from center to the middle of the river [m].}

\item{v}{Numeric. Flow velocity [m/s].}

\item{S}{Numeric. Safety factor, default is 1.5.}
}
\value{
Numeric. The difference between mean water level and superelevation [m].
}
\description{
Calculates the superelevation of the water table in a river curve.
}
\examples{
# Calculate superelevation
wt_sup(w = 30, rm = 200, v = 5)
}
\references{
Bezzola (2012). Flussbau, Vorlesungsmanuskript, ETH Zuerich
}
