% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{get.residuals}
\alias{get.residuals}
\title{Get pseudo residuals}
\usage{
get.residuals(model)
}
\arguments{
\item{model}{fitted hydroState model object.}
}
\value{
Data frame of residuals for each time-step
}
\description{
The pseudo residuals were derived from the conditional probabilities of the observations. At each time-step, the pseudo residual is the probability of an observation occurring given the prior observations and latter observations.
}
\details{
\code{get.residuals}

\code{get.residuals} retrieves residuals from the fitted model and exports them as a data frame.
}
\examples{
# Load fitted model
data(model.annual.fitted.221201)

## Get residuals in a dataframe
get.residuals(model = model.annual.fitted.221201)


}
\keyword{residuals}
