% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{class}
\name{Ib-class}
\alias{Ib-class}
\alias{IbBetareg-class}
\alias{IbGlm-class}
\alias{IbLm-class}
\alias{IbLmer-class}
\alias{IbGlmer-class}
\alias{IbNegbin-class}
\alias{IbNls-class}
\alias{IbVglm-class}
\alias{Ib}
\title{Fitted-model wrappers for the iterative bootstrap (\code{ib})}
\value{
Objects of the respective S4 classes.
}
\description{
S4 classes that wrap fitted model objects and attach extra metadata from the
iterative bootstrap procedure.

Members: \linkS4class{IbBetareg}, \linkS4class{IbGlm},
\linkS4class{IbLm}, \linkS4class{IbLmer}, \linkS4class{IbGlmer},
\linkS4class{IbNegbin}, \linkS4class{IbNls}, \linkS4class{IbVglm}.
}
\details{
Members include wrappers around models from \pkg{betareg}, \pkg{stats},
\pkg{lme4}, \pkg{MASS}, and \pkg{VGAM}.


These classes are light wrappers: they store the corrected fitted object in
\code{@object} (see \code{\link{getObject}}) and additional information in
\code{@ib_extra} (see \code{\link{getExtra}}).
}
\section{Slots}{

\describe{
\item{\code{object}}{The original fitted model object, corrected by \code{ib}.}

\item{\code{ib_extra}}{A \code{list} of extra metadata from \code{ib}.}
}}

\seealso{
\code{\link{getObject}}, \code{\link{getExtra}},
\linkS4class{Ib}, \linkS4class{SummaryIb}
}
