% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMetrics.R
\name{getMetrics}
\alias{getMetrics}
\title{Performance Measures}
\usage{
getMetrics(y, yhat, classtype)
}
\arguments{
\item{y}{expression. The class variable.}

\item{yhat}{expression. The vector of predicted values.}

\item{classtype}{character or numeric. The number of levels in \code{y}.}
}
\value{
Outputs an object with performance measures calculated from the confusion matrix given by the \code{caret} package. A data frame is the resulting output with the first column giving the name of the performance measure, and the second column giving the corresponding value.
}
\description{
this function allows to obtain performance measures from Confusion Matrix, it returns a data frame containing performance measures from the confusion matrix given by the \code{caret} package.
}
\details{
\code{getMetrics} works with target variables that have two, three, four, six or eight classes.

The function relies on the \code{caret} package to obtain the confusion matrix from which performance measures are extracted. It can be run for several algorithms, and the results combined into one data frame for easier comparison (see section 'Examples').

Predictions have to be obtained beforehand and used as input for \code{yhat}. The \code{predict.train} function in \code{caret} should be run without argument \code{type} when obtaining the predictions.
}
\examples{
if(interactive()){
# Obtain predictions from previous models
 
data(septoriaDurumWC)  
split.data <- splitData(septoriaDurumWC, seed = 1234, y = "ST_S", p = 0.7)
data.train <- split.data$trainset
data.test <- split.data$testset

knn.mod <- tuneTrain(data = septoriaDurumWC,y = 'ST_S',method = 'knn',positive = 'R')
nnet.mod <- tuneTrain(data = septoriaDurumWC,y = 'ST_S',method = 'nnet',positive = 'R') 

pred.knn <- predict(knn.mod$Model, newdata = data.test[ , -1])
pred.nnet <- predict(nnet.mod$Model, newdata = data.test[ , -1])

metrics.knn <- getMetrics(y = data.test$ST_S, yhat = pred.knn, classtype = 2)
metrics.nnet <- getMetrics(y = data.test$ST_S, yhat = pred.nnet, classtype = 2)
}
}
\seealso{
\code{\link[caret]{confusionMatrix}}
}
\author{
Zakaria Kehel, Bancy Ngatia, Khadija Aziz
}
