% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InfoMatrix.R
\name{InfoMatrix}
\alias{InfoMatrix}
\title{Compute the information matrix}
\usage{
InfoMatrix(object, initres)
}
\arguments{
\item{object}{Fit obtained from \code{fitit}}

\item{initres}{Result from \code{init}}
}
\value{
A list with three items
\item{Itrue}{Total of \code{Ifull} and \code{Iloss}, true Fisher information
matrix}
\item{Ifull}{Full Fisher information matrix}
\item{Iloss}{Loss of information due to intervals (missing event times)}
}
\description{
Compute the information matrix
}
\details{
Three information matrices are computed. One is \code{Ifull} which interprets
the imputed \code{R} and \code{Y} data from \code{object} as actual observations.
\code{Iloss} gives the loss of information due to imputation. The sum of both matrices
is the true information matrix.
}
