% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dig_vec}
\alias{dig_vec}
\alias{pcondig12_vec}
\alias{qcondig12_vec}
\title{Select IG copula quantities: matching inputs}
\usage{
dig_vec(u, v, theta, alpha)

pcondig12_vec(u, v, theta, alpha)

qcondig12_vec(p, v, theta, alpha)
}
\arguments{
\item{u, v}{Copula arguments. Vector of values between 0 and 1.}

\item{theta, alpha}{IG copula parameters. Vector of positive values.}

\item{p}{Function inverse argument. Vector of values between 0 and 1.}
}
\description{
The density function, 1|2 conditional cdf,
and 1|2 conditional quantile function of the IG
copula family. Inputs
need to be vectors of the same length.
These functions are called by the R functions of the
same name, without the \verb{_vec} suffix.
}
\details{
The \code{qcondig12()} function needs its own Newton
Raphson algorithm. It also needs access to some version
of \code{pcondig12()} and \code{dig()}. So, these three functions
are coded up in C++, each with a scalar and vector pair
of functions.
}
\note{
If calling these functions manually, make sure each input
are vectors of a common length.
}
\seealso{
\code{dig()}, \code{pcondig12()}, and \code{qcondig12()};
and \code{igl_gen_vec()} and family.
}
