% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations_utils.R
\name{make_seq_options}
\alias{make_seq_options}
\title{Build a \code{seq_options} list for sequence‑based receptor filtering}
\usage{
make_seq_options(
  query_col,
  patterns,
  method = c("exact", "lev", "hamm", "regex"),
  max_dist = NA,
  name_type = c("index", "pattern")
)
}
\arguments{
\item{query_col}{Character(1). Name of the receptor column to compare
(e.g. \code{"cdr3_aa"}).}

\item{patterns}{Character vector of sequences or regular expressions to
search for.}

\item{method}{One of \code{"exact"}, \code{"regex"}, \code{"lev"} (Levenshtein), or
\code{"hamm"} (Hamming).  Defaults to \code{"exact"}.}

\item{max_dist}{Numeric distance threshold for \code{"lev"} / \code{"hamm"}
filtering.  Use \code{NA} (default) to keep all rows after annotation.}

\item{name_type}{Passed straight to \code{annotate_tbl_distance()}; either
\code{"index"} (default) or \code{"pattern"}.}
}
\value{
A named list suitable for the \code{seq_options} argument of
\code{\link[=filter_receptors]{filter_receptors()}}.
}
\description{
A convenience wrapper that validates the common arguments for
\strong{\code{filter_receptors()}} and returns them in the required list form.
}
\seealso{
\code{\link[=filter_receptors]{filter_receptors()}}, \code{\link[=annotate_receptors]{annotate_receptors()}}
}
\concept{utils}
