% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impreciseEstimation.R
\name{impest}
\alias{impest}
\title{Imprecise Estimation}
\usage{
impest(data, event, constraints = NULL)
}
\arguments{
\item{data}{a data.frame obtained as result from an
imprecise imputation e.g. by a call to
\code{\link{impimp}}.}

\item{event}{a list of objects of class \code{"impimp_event"},
specifiying the event of interest. See 'Details'.}

\item{constraints}{a list of so-called logical constraints or
fixed zeros. Each element must be an object of class
\code{"impimp_event"}. See 'Details' .}
}
\value{
A numeric vector of length 2, where the
first component contains the lower and the second component
the upper probability of the event of interest.
}
\description{
Estimate the probability of some events
based on data obtained by imprecise imputation
}
\details{
\code{event} should be a list of objects of class
\code{"impmp_event"}, where the set union of impimp_events is the
actual event of interest.

By specifying \code{constraints} one can exlude combinations of
imputed values which are deemed impossible, so called
\sQuote{logical constraints} or \sQuote{fixed zeros}.
\code{constraints} should be a list of objects of class
\code{"impimp_event"}.

An object of class \code{"impimp_event"} is obtained as a result
of a call to \code{\link{impimp_event}}.

For both \code{event} and \code{constraints} holds that overlapping
in the resulting events generated by the individual impimp_events
does not have any side effects, besides a potential decrease
in performance.
}
\examples{
A <- data.frame(x1 = c(1,0), x2 = c(0,0),
                y1 = c(1,0), y2 = c(2,2))
B <- data.frame(x1 = c(1,1,0), x2 = c(0,0,0),
                z1 = c(0,1,1), z2 = c(0,1,2))
AimpB <- impimp(A, B, method = "variable_wise")
BimpA <- impimp(B, A, method = "variable_wise")
AB <- rbindimpimp(AimpB, BimpA)

## P(Z1=1, Z2=0)
myevent1 <- list(impimp_event(z1 = 1, z2 = 0))
impest(AB, event = myevent1)

## P[(Z1,Z2) in {(1,0),(0,1),(1,1)}]
myevent2 <- list(impimp_event(z1 = 1,z2 = 0),
                 impimp_event(z1 = c(0,1), z2 = 1))
impest(AB, event = myevent2)

}
\references{
Endres, E., Fink, P. and Augustin, T. (2018),
Imprecise Imputation: A Nonparametric Micro Approach Reflecting
the Natural Uncertainty of Statistical Matching with Categorical
Data, \emph{Department of Statistics (LMU Munich): Technical Reports},
No. 214
}
\seealso{
\code{\link{impimp}}, \code{\link{impimp_event}} for
sepcifying constraints and events; \code{\link{impestcond}} for
the estimation of conditional probabilities
}
\keyword{robust}
