% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spline_model.R
\name{train_and_validate}
\alias{train_and_validate}
\title{Train and validate model on reported data}
\usage{
train_and_validate(
  reported,
  delay_dist,
  lam,
  dof,
  beta0 = NULL,
  regularization_order = 2,
  reported_val = NULL,
  end_pad_size = 0,
  fisher_approx_cov = TRUE,
  num_samps_per_ar = 10
)
}
\arguments{
\item{reported}{An integer vector of reported cases.}

\item{delay_dist}{A positive vector that sums to one, which describes the delay distribution.}

\item{lam}{A fixed value for the beta parameter regularization strength.}

\item{dof}{Degrees of freedom for spline basis.}

\item{beta0}{(optional) Initial setting of spline parameters (before optimization)}

\item{regularization_order}{An integer (typically 0, 1, 2), indicating differencing order for L2 
regularization of spline parameters. Default is 2 for second derivative penalty.}

\item{reported_val}{Validation time series of equal size
to reported vector for use with 'val' method. Default is NULL.}

\item{end_pad_size}{And integer number of steps the spline is defined beyond the final 
observation.}

\item{fisher_approx_cov}{A flag to use either the Fisher Information (TRUE) or the Hessian (FALSE) to approx posterior covariance over parameters.}

\item{num_samps_per_ar}{An integer for the number of Laplace samples per AR fit.}
}
\value{
A list of results of train and validate, including: \itemize{ 
\item train_ll = training log likelihood
\item val_ll = validation log likelihood (if `reported_val` is not `NULL`)
 \item Isamps = samples of the incidence curve from a Laplace approximation
\item Ihat = MAP estimate of the incidence curve
	\item Chat = expected cases given MAP incidence curve
\item beta_hat = MAP estimate of spline parameters
\item beta_cov = covariance of spline parameters
\item beta_hess = Hessian of spline parameters}
}
\description{
This function fit models with selected hyperparameters on reported data and return a matrix of posterior Laplace samples.
}
