% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funlogic.R
\name{funlogic}
\alias{funlogic}
\alias{\%&\%}
\alias{\%|\%}
\alias{\%xor\%}
\title{Function Logical Operators}
\usage{
f1 \%&\% f2

f1 \%|\% f2

f1 \%xor\% f2
}
\arguments{
\item{f1, f2}{Arbitrary predicate functions.}
}
\description{
Creates a function which returns the corresponding logical
operation between what \code{f1} and \code{f2} return.
}
\details{
To obtain the logical negation of what a function \code{f} returns,
    use \code{base} function \code{\link[base]{Negate}}.
}
\examples{
is.null.na <- is.null \%|\% is.na
all(is.null.na(NA), is.null.na(NULL)) # returns TRUE
}
