% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_metrics.R
\name{betweenness}
\alias{betweenness}
\title{Vertex Betweenness centrality measure.}
\usage{
betweenness(g, snap = T)
}
\arguments{
\item{g}{The igraph object to analyze}

\item{snap}{True to use the SNAP betweenness code, False to use igraph::betweenness}
}
\value{
A numeric vector with the betweenness centrality score for each vertex
}
\description{
The Betweenness centrality score of a node u is the sum over all pairs s,t of the
proportion of shortest paths between s and t that pass through u. This 
function allows the use of either the SNAP betweenness implementation (default), or 
the igraph betweenness function. The SNAP version makes use of OpenMP for 
parallelization, and may be faster in some circumstances.
}
\examples{
ig.ex <- igraph::erdos.renyi.game(100, p.or.m=0.3) # generate an undirected 'igraph' object
betweenness(ig.ex) # betweenness scores for each node in the graph

}
\references{
\url{https://snap-graph.sourceforge.net/}
}
