% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_exposure.R
\name{calc_exposure}
\alias{calc_exposure}
\title{Calculate the exposure time}
\usage{
calc_exposure(injd, by = NULL, overall = TRUE, quiet = FALSE)
}
\arguments{
\item{injd}{\code{injd} \strong{S3} object (see
\code{\link[=prepare_all]{prepare_all()}}).}

\item{by}{Character specifying the name of the column according to which
compute summary statistics. It should refer to a (categorical) variable
that describes a grouping factor (e.g. "type of case or injury", "injury
location", "sports club"). Optional, defaults to \code{NULL}.}

\item{overall}{Logical, whether to calculate overall (for all the cohort) or
athlete-wise summary statistic (i.e. number of cases per cohort of per
athlete). Defaults to \code{TRUE}.}

\item{quiet}{Logical, whether or not to silence the warning messages
(defaults to \code{FALSE}).}
}
\value{
The total exposure time. Either a numeric value (if overall
\code{TRUE}) or a data frame indicating the total exposure time for each
athlete.
}
\description{
Calculate the time of exposure that each athlete, or the entire cohort of
athletes, has been at risk for a sport-related health problem.
}
\examples{
calc_exposure(injd)
calc_exposure(injd, overall = FALSE)
calc_exposure(injd, by = "injury_type")
}
