% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{require2}
\alias{require2}
\title{Loading Packages (and Installing them if they are missing)}
\usage{
require2(package, ask = FALSE, character.only = FALSE, min_version = 0)
}
\arguments{
\item{package}{A character of the name of a package (can also be without quotes).}

\item{ask}{Should the user be asked to install the require packaged, in case it is missing? (default is FALSE)}

\item{character.only}{logical (FALSE) - a logical indicating whether package or
help can be assumed to be character strings. Passed to \link{require}.}

\item{min_version}{Minimum version of package}
}
\value{
returns (invisibly) a logical indicating whether the required package is available.
}
\description{
require2 load add-on packages by passing it to \link{require}.
However, if the package is not available on the system, it will first install it (through \link{install.packages}),
and only then try to load it again.
}
\examples{
\dontrun{
require2("devtools")
require2(geonames)
require2(pkgbuild, min_version = "1.1.0")
data_table_loaded <- require2("data.table")
}
}
