#' Get data_sigma_group

#' @param obj A [pk()] object
#' @param newdata Optional: A `data.frame` with new data for which to get the
#'   `data_sigma_group`s. If NULL (the default), then the groups will be
#'   evaluated for the `obj$data`.
#' @param ... Additional arguments. Not currently in use.
#' @return A `factor` vector giving the error SD group ID for each observation,
#'   as the interaction of the factors specified in
#'   `obj$pk_groups$error_group`.
#' @export
#' @author Caroline Ring
get_data_sigma_group.pk <- function(obj,
                                    newdata = NULL, ...) {
if (is.null(newdata)) {
  newdata <- get_data(obj)
}

  data_sigma_group <- interaction(
    lapply(
      obj$pk_groups$error_group,
      rlang::eval_tidy,
      data = newdata
    )
  )

  return(data_sigma_group)
}
