% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{glance.ipd}
\alias{glance.ipd}
\title{Glance at an IPD Fit}
\usage{
\method{glance}{ipd}(x, ...)
}
\arguments{
\item{x}{An object of class \code{ipd}.}

\item{...}{Additional arguments to be passed to the glance function.}
}
\value{
A one-row data frame summarizing the IPD method/model fit.
}
\description{
Glances at the IPD method/model fit, returning a one-row summary.
}
\examples{

#-- Generate Example Data

set.seed(2023)

dat <- simdat(n = c(300, 300, 300), effect = 1, sigma_Y = 1)

head(dat)

formula <- Y - f ~ X1

#-- Fit IPD

fit <- ipd(formula, method = "postpi_analytic", model = "ols",

  data = dat, label = "set_label")

#-- Glance Output

glance(fit)

}
