% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi_mean.R
\name{ppi_mean}
\alias{ppi_mean}
\title{PPI Mean Estimation}
\usage{
ppi_mean(Y_l, f_l, f_u, alpha = 0.05, alternative = "two-sided")
}
\arguments{
\item{Y_l}{(vector): n-vector of labeled outcomes.}

\item{f_l}{(vector): n-vector of predictions in the labeled data.}

\item{f_u}{(vector): N-vector of predictions in the unlabeled data.}

\item{alpha}{(scalar): type I error rate for hypothesis testing - values in
(0, 1); defaults to 0.05.}

\item{alternative}{(string): Alternative hypothesis. Must be one of
\code{"two-sided"}, \code{"less"}, or \code{"greater"}.}
}
\value{
tuple: Lower and upper bounds of the prediction-powered confidence
interval for the mean.
}
\description{
Helper function for PPI mean estimation
}
\details{
Prediction Powered Inference (Angelopoulos et al., 2023)
\url{https://www.science.org/doi/10.1126/science.adi6000}
}
\examples{

dat <- simdat(model = "mean")

form <- Y - f ~ 1

Y_l <- dat[dat$set_label == "labeled",   all.vars(form)[1]] |> matrix(ncol = 1)

f_l <- dat[dat$set_label == "labeled",   all.vars(form)[2]] |> matrix(ncol = 1)

f_u <- dat[dat$set_label == "unlabeled", all.vars(form)[2]] |> matrix(ncol = 1)

ppi_mean(Y_l, f_l, f_u)

}
