% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracelines.R
\name{scp}
\alias{scp}
\title{Plot observed and predicted scores against ability}
\usage{
scp(resp, ip, theta = NULL)
}
\arguments{
\item{resp}{A matrix of binary responses to a test, with persons as rows and
items as columns.}

\item{ip}{Item parameters: the output of \code{est}, or a 3-column matrix 
corresponding to its first element, \code{est}.}

\item{theta}{An object containing ability estimates, as output by function
\code{mlebme} or \code{eap}.  If \code{NULL}, MLE will be estimated from
\code{resp} and \code{ip}.}
}
\value{
None
}
\description{
Produces a plot of IRT true scores (test response function at the estimated
ability) with a confidence band (plus/minus standard error). The observed
sum scores are shown in red.
}
\examples{

scp(Scored, Scored2pl)

}
\seealso{
\code{\link{mlebme}}, \code{\link{eap}}, \code{\link{tsc}},
\code{\link{trf}}
}
\author{
Ivailo Partchev
}
\keyword{models}
