% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icount.R
\name{icount}
\alias{icount}
\alias{icountn}
\title{Counting Iterators}
\usage{
icount(count = Inf, ..., recycle = FALSE, chunkSize, chunks)

icountn(vn, ..., recycle = FALSE, chunkSize, chunks, rowMajor = TRUE)
}
\arguments{
\item{count}{number of times that the iterator will fire. Use NA or
Inf to make an iterator that counts forever.}

\item{...}{Undocumented}

\item{recycle}{Whether to restart the count after finishing.}

\item{chunkSize}{How many valies to return from each call to nextOr().}

\item{chunks}{How many chunks to split the input. Either \code{chunks} or \code{chunkSize} may be given but not both.}

\item{vn}{A vector of integers.}

\item{rowMajor}{If \code{TRUE} (default), the earliest indices will cycle fastest;
if \code{FALSE}, last indices cycle fastest.}
}
\value{
The counting iterator.
}
\description{
Returns an iterator that counts starting from one.

\code{icountn(vn)} takes a vector specifying an array size,
and returns an iterator over array indices. Each returned element
is a vector the same length as vn, with the first index varying fastest.
If vn has a names attribute the output will have the same names.
}
\details{
Originally from the \code{iterators} package.
}
\examples{

# create an iterator that counts from 1 to 3.
it <- icount(3)
nextOr(it)
nextOr(it)
nextOr(it)
nextOr(it, NULL)  # expect NULL

x <- icount(5)
repeat print(nextOr(x, break))

it2 <- icount(100)
all.equal(as.numeric(it2), 1:100)
as.list(icountn(c(2, 3)))
}
\seealso{
For more control over starting number and step size, see
\link{iseq}.
}
