% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.plot.R
\name{info.plot}
\alias{info.plot}
\title{Plot the information function for a judge or for the entire set of judges.}
\usage{
info.plot(
  jrt.object,
  judge = "all",
  type = "information",
  title = "auto",
  column.names = "auto",
  theta.span = 3.5,
  y.limits = NULL,
  axis.title.info = "Information",
  axis.title.se = "Standard error",
  axis.title.reliability = "Reliability",
  axis.title.theta = expression(theta),
  y.line = NULL,
  name.for.y.line = "Threshold",
  y.line.refers.to.secondary.axis = TRUE,
  greyscale = FALSE,
  color.palette = "D3",
  line.type = 1,
  line.width = 1,
  key.width = 3,
  legend.position = "right",
  legend.columns = "",
  theme = "bw",
  text.size = 10,
  title.size = text.size + 4,
  remove.gridlines = TRUE,
  font.family = "sans",
  precision = 20,
  mirt.object.input = F,
  item = NULL
)
}
\arguments{
\item{jrt.object}{A object of the \code{jrt} class (created by the function \code{jrt}).}

\item{judge}{A numerical to indicate which judge to plot. Be careful : If a (Generalized) Rating Scale Model was used, then judges may have been removed for the model to be fitted. Provide \code{"all"} to get the information plot for all judges.}

\item{type}{A character to indicate what to plot on the y axis, \code{"information"} for Information, \code{"reliability"} for Reliability, or \code{"SE"} for standard errors. Alternatively, use \code{"infose"} (or \code{ise}) to plot information and standard error of measurement in the same plot. Use \code{"inforxx"} (or \code{ir}) to plot information and reliability in the same plot.}

\item{title}{A character title for the plot. By default it is created automatically based on the judge number.}

\item{column.names}{A character to indicate how a judge should be called (Defaults to \code{"auto"}, which uses what was set in the estimation function \code{jrt}, whose default is \code{"judge"}, but you may use \code{"Rater"}, \code{"Expert"}, etc.). This is used to create automatic titles.}

\item{theta.span}{A numeric indicating the maximum \eqn{\theta}. The minimum is automatically adjusted to \code{-theta.span}.}

\item{y.limits}{A numeric vector to manually adjust the minimum and maximum of the y axis (may notably be useful if using reliability). Set to \code{NULL} (default) to automatically set with \code{ggplot2}.}

\item{axis.title.info}{A character value to indicate how to name information on the y axis (only relevant if plotted). Note that you can also pass an expression (e.g., \code{expression(I(theta))}).}

\item{axis.title.se}{A character value to indicate how to name standard error on the y axis (only relevant if plotted). Note that you can also pass an expression (e.g., \code{expression(SE(theta))}).}

\item{axis.title.reliability}{A character value to indicate how to name reliability on the y axis (only relevant if plotted). Note that you can also pass an expression (e.g., \code{expression(r(theta))}).}

\item{axis.title.theta}{A character value to indicate how to name theta on the x axis. Note that you can also pass an expression (e.g., \code{expression(theta)}).}

\item{y.line}{A numeric to add a (dashed) horizontal line on the plot at the y value indicated (for example for a threshold of acceptable reliability). Defaults to \code{NULL}, which does not plot the line. Note that the y level is in reference to the primary axis, if there are two y axes.}

\item{name.for.y.line}{A character to indicate how to call the y line in the legend. Default is \code{"Threshold"}.}

\item{y.line.refers.to.secondary.axis}{A logical to indicate if the y.line should refer to a value on the secondary axis (\code{TRUE}, default) or the primary (\code{FALSE}). Only used if there is a secondary axis. The default is \code{TRUE} because threshold values for interpretation are more often used for reliability or standard error than information.}

\item{greyscale}{A logical (default is \code{FALSE}) to indicate whether to use greyscale graphics (useful for publication). Uses variations in linetype as opposed to variations in line colors.}

\item{color.palette}{A character value to indicate the colour palette to use. Defaults to \code{"D3"} from "ggsci". Use \code{""} for the default of \code{ggplot2}. The palettes are supplied as arguments in the \code{scale_fill_brewer()} function of \code{ggplot2}. In addition, most palettes from the package \code{ggsci} are available (e.g., \code{"npg"}, \code{"aas"}, \code{"nejm"}, \code{"lancet"}, \code{"jama"}, \code{"d3"}). Use \code{vignette("ggsci")} for details.}

\item{line.type}{A numeric indicating the line type for the information function curve (default is \code{1} for a plain line. This would be used if overlaying multiple plots.}

\item{line.width}{A numeric indicating the width for the information function curve (default is \code{2.5}).}

\item{key.width}{A numeric to indicate the width of the legend key (default is \code{3}).}

\item{legend.position}{A character string or vector of coordinates to position the legend key. Defaults to \code{"right"}. Other possibilities include notably \code{"bottom"}.}

\item{legend.columns}{A numeric to indicate after how many legend key elements to add a line break. Especially useful if using \code{legend.position = "bottom"} if you want line breaks between each key. Defaults to \code{""}, which automatically saves space based on the legend position (line breaks are used if the legend in positioned on the side of the graph).}

\item{theme}{A character value to indicate the background color theme used by \code{ggplot2}. Defaults to \code{"bw"}. Can be \code{"light"}, \code{"dark"}, \code{"minimal"}, \code{"classic"}, \code{"gray"}, \code{"bw"} or \code{"linedraw"}.}

\item{text.size}{A numeric value to control the size of the text on the plot.}

\item{title.size}{A numeric value to control the size of the plot title (defaults to \code{text.size+4}).}

\item{remove.gridlines}{A logical value to remove the gridlines (default is \code{TRUE}).}

\item{font.family}{A character value to control the font family used on the graph. Defaults to \code{"sans"}. Other possible values include \code{"serif"} or \code{"mono"}.}

\item{precision}{A numeric to indicate the degree of precision used to plot the curves. Higher values will increase the accuracy of the graph and make the curves look smoother, but the data generated to plot the graph will be bigger, which will slow down the function. Lower values will do the opposite. Values between \code{10} and \code{100} are recommended, \code{20} is the default and sufficient for most uses.}

\item{mirt.object.input}{A logical allowing to input directly an \code{mirt} object as a \code{jrt.object} argument, even though this should be detected automatically. See \code{mirt} package documentation, and note that this is a secondary use that may lead to inconsistent results at this point.}

\item{item}{For convenience, this argument, more standard to IRT packages, can be used instead of the \code{judge} argument.}
}
\value{
A plot of the information, reliability or standard error function.
}
\description{
This function returns the Judge Information Function plot from a \code{jrt} object and the judge number. Information can be plotted as such, as reliability or as standard error. The function may also be used for the information of the entire set of judges. This is a wrapper function and adaptation of the \code{itemplot} function in the package \code{mirt} (Chalmers, 2012). It also uses the plotting functions of the packages \code{directlabels} and \code{ggplot2}.
}
\examples{

# Load dataset
data <- jrt::ratings

# Fit model
fit <- jrt(data, irt.model = "PCM")

# Information function of the first judge
info.plot(fit, 1)

# Reliability function of the second judge
info.plot(fit, 2, type = "reliability")

# Standard error function of the entire set of judges
info.plot(fit, "all", type = "SE")

# See vignette for more options

}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29. \doi{10.18637/jss.v048.i06}

Myszkowski, N., & Storme, M. (2019). Judge Response Theory? A call to upgrade our psychometrical account of creativity judgments. \emph{Psychology of Aesthetics, Creativity and the Arts, 13}(2), 167-175. \doi{10.1037/aca0000225}

Myszkowski, N. (2021). Development of the R library “jrt”: Automated item response theory procedures for judgment data and their application with the consensual assessment techniques. \emph{Psychology of Aesthetics, Creativity and the Arts, 15}(3), 426-438. \doi{10.1037/aca0000287}
}
