% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{rectangular}
\alias{rectangular}
\title{Rectangular kernel}
\usage{
rectangular(x, a = -0.5, b = 0.5)
}
\arguments{
\item{x}{Numeric vector.}

\item{a}{Numeric scalar: lower bound of kernel support; defaults to -0.5.}

\item{b}{Numeric scalar: upper bound of kernel support; defaults to 0.5.}
}
\value{
A numeric vector of the rectangular kernel evaluated at the
        values in \code{x}.
}
\description{
Vectorized evaluation of the rectangular kernel.
}
\examples{
kader:::rectangular(x = seq(-1, 1, by = 0.1))
\donttest{
curve(kader:::rectangular(x), from = -1, to = 1)
}

}
