% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway.r
\name{pathway}
\alias{pathway}
\alias{pathway,ANY-method}
\alias{show,pathway-method}
\alias{show,pathway,ANY-method}
\alias{summary,pathway-method}
\alias{summary,pathway,ANY-method}
\alias{pathway2igraph,pathway-method}
\alias{pathway2igraph}
\alias{ANY-method}
\alias{analyze,pathway-method}
\alias{analyze}
\alias{get_genes,pathway-method}
\alias{get_genes}
\alias{plot,pathway,missing-method}
\alias{plot,pathway,ANY-method}
\alias{sample_genes,pathway-method}
\alias{sample_genes}
\title{An S4 class to represent a gene-gene interaction network}
\usage{
pathway(object, ...)

\S4method{pathway}{ANY}(id, adj = matrix(0), sign = NULL)

\S4method{show}{pathway}(object)

\S4method{summary}{pathway}(object)

\S4method{pathway2igraph}{pathway}(object)

\S4method{analyze}{pathway}(object, ...)

\S4method{get_genes}{pathway}(object)

\S4method{plot}{pathway,missing}(
  x,
  y = NA,
  highlight.genes = NULL,
  gene.names = c(NULL, "legend", "nodes"),
  main = NULL,
  asp = 0.95,
  vertex.size = 11,
  vertex.color = "khaki1",
  vertex.label.cex = 0.8,
  edge.width = 2,
  edge.color = "olivedrab4",
  ...
)

\S4method{sample_genes}{pathway}(object, no = 3)
}
\arguments{
\item{object}{An object of class \code{pathway-class}}

\item{...}{Further arguments can be added to the function.}

\item{id}{A \code{character} repesenting the \code{\link{pathway}} id.}

\item{adj}{A \code{matrix} respresenting the network adjacency matrix of dimension 
equaling the number of genes (1 interaction, 0 otherwise)}

\item{sign}{A \code{numeric} \code{vector} indicating the interaction type for
each link (1 activation, -1 inhibition) in the interaction network for the \code{\link{pathway}}.}

\item{x}{\code{\link{pathway}} object}

\item{y}{missing (placeholder)}

\item{highlight.genes}{vector of gene names or node id's, which should be highlighted in a different color, default is \code{NULL} so that no genes are highlighted}

\item{gene.names}{character indicating whether the genes names should appear in a legend (\code{'legend'}), as vertex label (\code{'nodes'}), or should be omitted (\code{NA})}

\item{main}{optional overall main title, default is \code{NULL}, which uses the \code{\link{pathway}} id}

\item{asp}{a \code{numeric} constant, which gives the aspect ratio parameter for plot, default is 0.95}

\item{vertex.size}{a \code{numeric} constant specifying the vertex size, default is 11}

\item{vertex.color}{a \code{character} or \code{numeric} constant specifying the vertex color, default is 'khaki1'}

\item{vertex.label.cex}{a \code{numeric} constant specifying the the vertex label size, default is 0.8,}

\item{edge.width}{a \code{numeric} constant specifying the edge width, default is 2}

\item{edge.color}{a \code{character} or \code{numeric} constant specifying the edge color, default is 'olivedrab4'}

\item{no}{a \code{numeric} constant specifying the number of genes to be sampled, default is 3}
}
\value{
\code{pathway2igraph} returns an unweighted \code{\link[igraph]{igraph}} object with edge attribute \code{sign}

\code{analyze} returns a \code{data.frame} consisting of 
  \describe{
   \item{id}{pathway id,} 
   \item{vcount}{number of genes,}
   \item{ecount}{number of links,}
   \item{inh_ecount}{number of inhibition links,}
   \item{density}{network density,}
   \item{av_deg}{average degree,}
   \item{inh_deg}{average degree of inhibition links,}
   \item{diam}{network diamter,}
   \item{trans}{transitivity, and }
   \item{s_trans}{signed transitivity (Kunegis et al., 2009).}
}

\code{get_genes} returns a character vector of gene names extracted from adjacency matrix rownames.

\code{sample_genes} returns a \code{vector} of length \code{no} with 
vertex id's of sampled genes
}
\description{
An S4 class to represent a gene-gene interaction network

\code{pathway} is the \code{\link{pathway}} object constructor.

\code{show} displays the \code{\link{pathway}} object briefly

\code{summary} generates a \code{\link{pathway}} object summary including basic network properties.

\code{pathway2igraph} converts a \code{\link{pathway}} object into an 
\code{\link[igraph]{igraph}} object with edge attribute \code{sign}

analyze \code{\link{pathway}} network properties

\code{get_genes} is a helper function that extracts the gene names in a 
\code{\link{pathway}} and returns a \code{vector} containing \code{character}
elements of gene names

\code{plot} visualizes the \code{\link{pathway}} as \code{\link[igraph]{igraph}} object

\code{sample_genes} randomly selects effect gene in a 
\code{\link{pathway}} according the betweenness centrality and (no -1) neighors
}
\section{Methods (by generic)}{
\itemize{
\item \code{analyze(pathway)}: 

\item \code{get_genes(pathway)}: 

\item \code{sample_genes(pathway)}: 

}}
\section{Slots}{

\describe{
\item{\code{id}}{A \code{character} repesenting the \code{\link{pathway}} id, 
e.g. hsa00100 as used in the KEGG database.}

\item{\code{adj}}{A \code{matrix} respresenting the network adjacency matrix of dimension 
equaling the number of genes (1 interaction, 0 otherwise)}

\item{\code{sign}}{A \code{numeric} \code{vector} indicating the interaction type for 
each link (1 activation, -1 inhibition) in the interaction network for the 
\code{\link{pathway}}.}
}}

\examples{
# pathway object constructor
pathway(id="hsa04022")

# convert to igraph object
data(hsa04020)
str(hsa04020)
g <- pathway2igraph(hsa04020)
str(g)

# analyze pathway network properties
data(hsa04020)
summary(hsa04020)
analyze(hsa04020)

# extract gene names from pathway object
get_genes(hsa04020)

# plot pathway as igraph object
plot(hsa04020)
sample3 <- sample_genes(hsa04020, no = 3)
plot(hsa04020, highlight.genes = sample3)

# sample effect genes
sample3 <- sample_genes(hsa04020, no = 3)
plot(hsa04020, highlight.genes = sample3)
sample5 <- sample_genes(hsa04020, no = 5)
plot(hsa04020, highlight.genes = sample5)

}
\references{
Details to the computation and interpretation can be found in:
\itemize{
  \item Kolaczyk, E. D. (2009). Statistical analysis of network data: methods and models. Springer series in statistics. Springer.
  \item Kunegis, J., A. Lommatzsch, and C. Bauckhage (2009). The slashdot zoo: Mining a social network with negative egdes. In Proceedings of the 18th international conference on World wide web, pp. 741-750. ACM Press.
}
}
\author{
Juliane Manitz, Stefanie Friedrichs, Patricia Burger
}
